/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoConnectionProperties;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.CustomNavigationItemAdapter;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.DefaultCMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.DemoMenuBarFormater;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.ListTemplate;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.MenuBarFormater;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.NavigationItemAdapter;
import fr.toutatice.portail.cms.nuxeo.portlets.list.DocumentQueryCommand;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletContext;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSHandlerProperties;
import org.osivia.portal.core.cms.CMSServiceCtx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMSCustomizer
extends DefaultCMSCustomizer {
    public static final String ACTUALITE = "actualite";
    public static final String ENCADRE = "encadre";
    public static final String ENCADRE_NIVEAU2 = "encadre_niveau2";
    public static final String VISUEL_NIVEAU2 = "visuel_niveau2";
    public static final String UNE_NIVEAU2 = "une_niveau2";
    public static final String UNE_TITRE_NIVEAU3_1C = "une_titre_niveau3_1c";
    public static final String UNE_NIVEAU3_1C = "une_niveau3_1c";
    public static final String VISUEL_NIVEAU3 = "visuel_niveau3";
    public static final String BLOG_SCHEMAS = "dublincore,common, toutatice, note";
    public static final String ANNONCE_SCHEMAS = "dublincore,common, toutatice, note, annonce";
    public static String TEMPLATE_DOWNLOAD = "download";
    public static final String IDENT_WIKI_URL = "/_WIKI_";

    public CMSCustomizer(PortletContext ctx) {
        super(ctx);
    }

    public NavigationItemAdapter getNavigationItemAdapter() {
        if (this.navigationItemAdapter == null) {
            this.navigationItemAdapter = new CustomNavigationItemAdapter(this.portletCtx, (DefaultCMSCustomizer)this, this.getCMSService());
        }
        return this.navigationItemAdapter;
    }

    public static List<ListTemplate> getListTemplates() {
        List templates = DefaultCMSCustomizer.getListTemplates();
        templates.add(new ListTemplate(ACTUALITE, "Actualit\u00e9", ANNONCE_SCHEMAS));
        templates.add(new ListTemplate(ENCADRE, "Encadr\u00e9", ANNONCE_SCHEMAS));
        templates.add(new ListTemplate(ENCADRE_NIVEAU2, "Encadr\u00e9 niveau 2", "dublincore,common, toutatice, file"));
        templates.add(new ListTemplate(VISUEL_NIVEAU2, "Visuel niveau 2", "dublincore,common, toutatice, file"));
        templates.add(new ListTemplate(UNE_NIVEAU2, "Une niveau 2", BLOG_SCHEMAS));
        templates.add(new ListTemplate(UNE_NIVEAU3_1C, "Une niveau 3 - 1 colonne", BLOG_SCHEMAS));
        templates.add(new ListTemplate(UNE_TITRE_NIVEAU3_1C, "Une Titre niveau 3 - 1 colonne", BLOG_SCHEMAS));
        templates.add(new ListTemplate(VISUEL_NIVEAU3, "Visuel niveau 3", "dublincore,common, toutatice, file"));
        return templates;
    }

    public static String getSearchSchema() {
        return "dublincore,common, toutatice, wcm_navigation, wcm_content";
    }

    public String getNuxeoNativeViewerUrl(CMSServiceCtx ctx) {
        String url = null;
        Document doc = (Document)ctx.getDoc();
        if ("PictureBook".equals(doc.getType())) {
            this.getNuxeoConnectionProps();
            url = NuxeoConnectionProperties.getPublicBaseUri().toString() + "/nxdoc/default/" + doc.getId() + "/view_documents?tabId=tab_slideshow";
        }
        if ("Forum".equals(doc.getType())) {
            url = this.getDefaultExternalViewer(ctx);
        }
        return url;
    }

    public MenuBarFormater getMenuBarFormater() {
        if (this.menuBarFormater == null) {
            this.menuBarFormater = new DemoMenuBarFormater(this.portletCtx, (DefaultCMSCustomizer)this, this.getCMSService());
        }
        return this.menuBarFormater;
    }

    public CMSHandlerProperties getCMSDefaultPlayer(CMSServiceCtx ctx) throws Exception {
        Document doc = (Document)ctx.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.cms.scope", ctx.getScope());
        windowProperties.put("osivia.hideTitle", "1");
        windowProperties.put("osivia.cms.displayLiveVersion", ctx.getDisplayLiveVersion());
        windowProperties.put("osivia.cms.hideMetaDatas", ctx.getHideMetaDatas());
        windowProperties.put("osivia.cms.uri", doc.getPath());
        windowProperties.put("osivia.cms.publishPathAlreadyConverted", "1");
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewDocumentPortletInstance");
        return linkProps;
    }

    public Map<String, String> parseCMSURL(CMSServiceCtx cmsCtx, String requestPath, Map<String, String> requestParameters) throws Exception {
        HashMap<String, String> cmsCommandProperties = new HashMap();
        if (requestPath.startsWith(IDENT_WIKI_URL)) {
            String[] ident = requestPath.split("/");
            String clause = " ecm:primaryType = 'WikiSection' and webc:url = '" + ident[2] + "'";
            String filteredClause = NuxeoQueryFilter.addPublicationFilter((String)clause, (boolean)false);
            Documents documents = (Documents)this.getCMSService().executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentQueryCommand(filteredClause));
            if (documents.size() != 1) {
                throw new CMSException(CMSException.ERROR_NOTFOUND);
            }
            cmsCommandProperties.put("cmsPath", documents.get(0).getPath());
        } else {
            cmsCommandProperties = super.parseCMSURL(cmsCtx, requestPath, requestParameters);
        }
        return cmsCommandProperties;
    }

    public CMSHandlerProperties getCMSPlayer(CMSServiceCtx ctx) throws Exception {
        Document doc = (Document)ctx.getDoc();
        if ("WikiBook".equals(doc.getType()) || "WikiSection".equals(doc.getType())) {
            return this.getWikiPlayer(ctx);
        }
        return super.getCMSPlayer(ctx);
    }

    public CMSHandlerProperties getWikiPlayer(CMSServiceCtx ctx) throws Exception {
        Document doc = (Document)ctx.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.cms.uri", doc.getPath());
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("osivia.ajaxLink", "1");
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("osivia-services-wiki-wikiPortletInstance");
        return linkProps;
    }
}

