/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers;

import fr.toutatice.portail.cms.nuxeo.portlets.customizer.DefaultCMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.service.CMSService;
import java.util.Map;
import javax.portlet.PortletContext;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.core.cms.CMSItem;

public class NavigationItemAdapter {
    CMSService CMSService;
    DefaultCMSCustomizer customizer;
    PortletContext portletCtx;

    public NavigationItemAdapter(PortletContext portletCtx, DefaultCMSCustomizer customizer, CMSService cmsService) {
        this.CMSService = cmsService;
        this.portletCtx = portletCtx;
        this.customizer = customizer;
    }

    protected String getDefaultPageTemplate(Document doc) {
        return "/default/templates/portalSitePublish";
    }

    protected boolean isNavigable(Document doc) {
        return doc.getType().equals("PortalPage") || doc.getType().equals("Folder") || doc.getType().equals("OrderedFolder") || doc.getType().equals("DocumentUrlContainer") || doc.getType().equals("AnnonceFolder") || doc.getType().equals("PortalVirtualPage") || doc.getType().equals("SimplePage");
    }

    protected boolean isDisplayedAsAPage(Document doc) {
        return doc.getType().equals("PortalPage") || doc.getType().equals("SimplePage");
    }

    protected boolean isShowInMenu(Document doc) {
        return false;
    }

    public void adaptPublishSpaceNavigationItem(CMSItem publishSpaceNavigationItem, CMSItem publishSpaceItem) {
        String contextualizeExternalContents;
        String contextualizeInternalContents;
        String hideInNavigation;
        String pageScope;
        String childrenPageTemplate;
        Document doc = (Document)publishSpaceNavigationItem.getNativeItem();
        Map properties = publishSpaceNavigationItem.getProperties();
        String title = (String)doc.getProperties().get("dc:title");
        if (title != null) {
            properties.put("title", title);
        }
        String pageTemplate = (String)doc.getProperties().get("ttc:pageTemplate");
        boolean defaultTemplate = false;
        if (publishSpaceNavigationItem.getPath().equals(publishSpaceItem.getPath())) {
            if (pageTemplate == null || pageTemplate.length() == 0) {
                pageTemplate = this.getDefaultPageTemplate(doc);
                defaultTemplate = true;
            }
            properties.put("navigationElement", "1");
            properties.put("pageDisplayMode", "1");
        }
        if (pageTemplate != null && pageTemplate.length() > 0) {
            if (defaultTemplate) {
                properties.put("defaultTemplate", "1");
            }
            properties.put("pageTemplate", pageTemplate);
        }
        if (StringUtils.isNotEmpty((String)(childrenPageTemplate = (String)doc.getProperties().get("ttc:childrenPageTemplate")))) {
            properties.put("childrenPageTemplate", childrenPageTemplate);
        }
        if ((pageScope = (String)doc.getProperties().get("ttc:pageScope")) != null && pageScope.length() > 0) {
            properties.put("pageScope", pageScope);
        }
        if ((hideInNavigation = (String)doc.getProperties().get("ttc:hideInNavigation")) != null && "true".equals(hideInNavigation)) {
            properties.put("hideInNavigation", "1");
        }
        if (this.isNavigable(doc) && !"1".equals(properties.get("hideInNavigation"))) {
            properties.put("navigationElement", "1");
        }
        String showInMenu = (String)doc.getProperties().get("ttc:showInMenu");
        if (this.isShowInMenu(doc) || showInMenu != null && "true".equals(showInMenu)) {
            properties.put("menuItem", "1");
        }
        if (this.isDisplayedAsAPage(doc)) {
            properties.put("pageDisplayMode", "1");
        }
        if ((contextualizeInternalContents = (String)doc.getProperties().get("ttc:contextualizeInternalContents")) != null && "true".equals(contextualizeInternalContents)) {
            properties.put("contextualizeInternalContents", "1");
        }
        if ((contextualizeExternalContents = (String)doc.getProperties().get("ttc:contextualizeExternalContents")) != null && "true".equals(contextualizeExternalContents)) {
            properties.put("contextualizeExternalContents", "1");
        }
        if ("Workspace".equals(doc.getType())) {
            properties.put("contextualizeInternalContents", "1");
            properties.put("contextualizeExternalContents", "1");
            if (StringUtils.isEmpty((String)((String)doc.getProperties().get("ttc:pageTemplate")))) {
                properties.put("pageTemplate", "/default/templates/workspace");
            }
            properties.put("displayLiveVersion", "1");
        }
        if ("UserWorkspace".equals(doc.getType())) {
            properties.put("contextualizeInternalContents", "1");
            properties.put("contextualizeExternalContents", "1");
            properties.put("pageTemplate", "/default/templates/userworkspace");
            properties.put("displayLiveVersion", "1");
        }
        if ("Workspace".equals(doc.getType())) {
            properties.put("partialLoading", "1");
        }
        if ("WebSite".equals(doc.getType()) || "BlogSite".equals(doc.getType())) {
            properties.put("contextualizeInternalContents", "1");
            properties.put("contextualizeExternalContents", "1");
        }
    }
}

