/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.IFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.SpaceMenuBarFragmentModule;
import java.util.HashMap;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.core.cms.CMSServiceCtx;

public class SpaceMenuBarFragmentModule
implements IFragmentModule {
    public static final String ITEM_TYPE = "itemType";
    public static final String WINDOW_ITEM_TYPE = "osivia.itemType";
    public static final String ITEM_NAME = "itemName";
    public static final String WINDOW_ITEM_NAME = "osivia.itemName";
    public static final String ITEM_POS = "itemPos";
    public static final String WINDOW_ITEM_POS = "osivia.itemPos";
    public static final String ITEM_CLICK = "itemClick";
    public static final String WINDOW_ITEM_CLICK = "osivia.itemClick";
    public static final String ITEM_CSS_CLASSES = "cssItemClass";
    public static final String WINDOW_ITEM_CSS_CLASSES = "osivia.cssItemClass";
    public static final String MENU_BAR = "osivia.menuBar";
    public static final String SPACE_PATH = "${basePath}";
    public static final String PERMLINK_VALUE = "permlinkValue";
    public static final String ITEMS = "items";
    public static final String CHECKED = "checked=\"checked\"";
    public static final String CHECKBOXES = "checkboxes";
    public static final String SEPARATOR = ",";

    public void injectViewAttributes(NuxeoController ctrl, PortalWindow window, PortletRequest request, RenderResponse response) throws Exception {
        String itemsStr = window.getProperty(ITEMS);
        String[] items = itemsStr.split(SEPARATOR);
        if (items != null) {
            for (String item : items) {
                String itemName = window.getProperty(WINDOW_ITEM_NAME + item);
                String itemPosStr = window.getProperty(WINDOW_ITEM_POS + item);
                int itemPos = 0;
                if (itemPosStr != null) {
                    itemPos = Integer.valueOf(itemPosStr);
                }
                String onClick = window.getProperty(WINDOW_ITEM_CLICK + item);
                String cssClasses = window.getProperty(WINDOW_ITEM_CSS_CLASSES + item);
                List menuBar = (List)request.getAttribute(MENU_BAR);
                String spacePath = ctrl.getComputedPath(SPACE_PATH);
                if (ItemTypes.EDIT.toString().equalsIgnoreCase(item)) {
                    Document space = ctrl.fetchDocument(spacePath);
                    String url = ctrl.getLink(space, "nuxeo-link").getUrl();
                    MenubarItem editItem = new MenubarItem(item, itemName, itemPos, url, onClick, cssClasses, "nuxeo");
                    editItem.setAjaxDisabled(true);
                    menuBar.add(editItem);
                    continue;
                }
                if (!ItemTypes.PERMLINK.toString().equalsIgnoreCase(item)) continue;
                CMSServiceCtx cmsCtx = ctrl.getCMSCtx();
                PortletContext portletCtx = cmsCtx.getPortletCtx();
                IPortalUrlFactory urlFactory = this.getPortalUrlFactory(portletCtx);
                if (urlFactory != null) {
                    String permaLinkURL = urlFactory.getPermaLink(new PortalControllerContext(portletCtx, request, (PortletResponse)response), null, null, spacePath, "cms");
                    MenubarItem permlinkItem = new MenubarItem(item, itemName, itemPos, permaLinkURL, onClick, cssClasses, null);
                    permlinkItem.setAjaxDisabled(true);
                    menuBar.add(permlinkItem);
                    request.setAttribute(PERMLINK_VALUE, (Object)permaLinkURL);
                    continue;
                }
                throw new Exception("Le service UrlService n'est pas disponible");
            }
        }
    }

    public void injectAdminAttributes(NuxeoController ctx, PortalWindow window, PortletRequest request, RenderResponse response) throws Exception {
        String[] items;
        HashMap<String, String> itemsChecked = new HashMap<String, String>();
        String itemsStr = window.getProperty(ITEMS);
        if (itemsStr != null && (items = itemsStr.split(SEPARATOR)) != null) {
            for (String item : items) {
                itemsChecked.put(item, CHECKED);
                String itemName = window.getProperty(WINDOW_ITEM_NAME + item);
                if (itemName == null) {
                    itemName = "";
                }
                request.setAttribute(ITEM_NAME + item, (Object)itemName);
                String itemPos = window.getProperty(WINDOW_ITEM_POS + item);
                if (itemPos == null) {
                    itemPos = "";
                }
                request.setAttribute(ITEM_POS + item, (Object)itemPos);
                String itemClick = window.getProperty(WINDOW_ITEM_CLICK + item);
                if (itemClick == null) {
                    itemClick = "";
                }
                request.setAttribute(ITEM_CLICK + item, (Object)itemClick);
                String cssItemClass = window.getProperty(WINDOW_ITEM_CSS_CLASSES + item);
                if (cssItemClass == null) {
                    cssItemClass = "";
                }
                request.setAttribute(ITEM_CSS_CLASSES + item, (Object)cssItemClass);
            }
        }
        request.setAttribute(CHECKBOXES, itemsChecked);
    }

    public void processAdminAttributes(NuxeoController ctx, PortalWindow window, ActionRequest request, ActionResponse response) throws Exception {
        String[] items = request.getParameterValues(ITEMS);
        String savedItems = "";
        if (items != null) {
            for (String item : items) {
                String cssItemClass;
                String itemClick;
                String itemPos;
                savedItems = savedItems + item + SEPARATOR;
                String itemName = request.getParameter(ITEM_NAME + item);
                if (itemName != null) {
                    if (itemName.length() > 0) {
                        window.setProperty(WINDOW_ITEM_NAME + item, itemName);
                    } else if (window.getProperty(WINDOW_ITEM_NAME + item) != null) {
                        window.setProperty(WINDOW_ITEM_NAME + item, null);
                    }
                }
                if ((itemPos = request.getParameter(ITEM_POS + item)) != null) {
                    if (itemPos.length() > 0) {
                        window.setProperty(WINDOW_ITEM_POS + item, itemPos);
                    } else if (window.getProperty(WINDOW_ITEM_POS + item) != null) {
                        window.setProperty(WINDOW_ITEM_POS + item, null);
                    }
                }
                if ((itemClick = request.getParameter(ITEM_CLICK + item)) != null) {
                    if (itemClick.length() > 0) {
                        window.setProperty(WINDOW_ITEM_CLICK + item, itemClick);
                    } else if (window.getProperty(WINDOW_ITEM_CLICK + item) != null) {
                        window.setProperty(WINDOW_ITEM_CLICK + item, null);
                    }
                }
                if ((cssItemClass = request.getParameter(ITEM_CSS_CLASSES + item)) == null) continue;
                if (cssItemClass.length() > 0) {
                    window.setProperty(WINDOW_ITEM_CSS_CLASSES + item, cssItemClass);
                    continue;
                }
                if (window.getProperty(WINDOW_ITEM_CSS_CLASSES + item) == null) continue;
                window.setProperty(WINDOW_ITEM_CSS_CLASSES + item, null);
            }
            window.setProperty(ITEMS, savedItems);
        }
    }

    public IPortalUrlFactory getPortalUrlFactory(PortletContext portletCtx) throws Exception {
        return (IPortalUrlFactory)portletCtx.getAttribute("UrlService");
    }
}

