/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.document;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.core.cms.CMSBinaryContent;

public class FileContentCommand
implements INuxeoCommand {
    Document document;
    String docPath;
    String fieldName;

    public FileContentCommand(Document document, String fieldName) {
        this.document = document;
        this.docPath = null;
        this.fieldName = fieldName;
    }

    public FileContentCommand(String docPath, String fieldName) {
        this.document = null;
        this.docPath = docPath;
        this.fieldName = fieldName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Session session) throws Exception {
        if (this.document == null) {
            this.document = (Document)session.newRequest("Document.Fetch").setHeader("X-NXDocumentProperties", "*").set("value", (Object)this.docPath).execute();
        }
        PropertyMap map = this.document.getProperties().getMap(this.fieldName);
        String pathFile = map.getString("data");
        FileBlob blob = (FileBlob)session.getFile(pathFile);
        FileInputStream in = new FileInputStream(blob.getFile());
        File tempFile = File.createTempFile("tempFile1", ".tmp");
        FileOutputStream out = new FileOutputStream(tempFile);
        try {
            byte[] b = new byte[4096];
            int i = -1;
            while ((i = ((InputStream)in).read(b)) != -1) {
                ((OutputStream)out).write(b, 0, i);
            }
            out.flush();
        }
        finally {
            ((InputStream)in).close();
        }
        blob.getFile().delete();
        CMSBinaryContent content = new CMSBinaryContent();
        String fileName = blob.getFileName();
        if (fileName == null || "null".equals(fileName)) {
            fileName = this.document.getTitle();
        }
        content.setName(fileName);
        content.setFile(tempFile);
        content.setMimeType(blob.getMimeType());
        return content;
    }

    public String getId() {
        String id = "FileContentCommand";
        id = this.document == null ? id + this.docPath : id + this.document;
        id = id + "/" + this.fieldName;
        return id;
    }
}

