/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.files;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.PortletErrorHandler;
import fr.toutatice.portail.cms.nuxeo.api.services.DocTypeDefinition;
import fr.toutatice.portail.cms.nuxeo.portlets.document.DeleteDocumentCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.files.FileBrowserPortlet;
import fr.toutatice.portail.cms.nuxeo.portlets.files.FolderGetFilesCommand;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSecurityException;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSPublicationInfos;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class FileBrowserPortlet
extends CMSPortlet {
    public static boolean isNavigable(Document doc) {
        return "Folder".equals(doc.getType()) || "OrderedFolder".equals(doc.getType()) || "Workspace".equals(doc.getType()) || "WorkspaceRoot".equals(doc.getType()) || "PortalSite".equals(doc.getType()) || "Section".equals(doc.getType()) || "SectionRoot".equals(doc.getType());
    }

    public static boolean isOrdered(Document doc) {
        return "Workspace".equals(doc.getType()) || "WorkspaceRoot".equals(doc.getType()) || "OrderedFolder".equals(doc.getType()) || "PortalSite".equals(doc.getType()) || "PortalPage".equals(doc.getType()) || "WikiBook".equals(doc.getType()) || "WikiSection".equals(doc.getType());
    }

    public static boolean isFolderish(Document doc) {
        return "PictureBook".equals(doc.getType()) || "DocumentUrlContainer".equals(doc.getType()) || FileBrowserPortlet.isNavigable((Document)doc);
    }

    public static Comparator<Document> createComparator(Document parentDoc) {
        1 comparator = new /* Unavailable Anonymous Inner Class!! */;
        return comparator;
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws PortletException, IOException {
        try {
            if ("fileActions".equals(resourceRequest.getParameter("type"))) {
                NuxeoController ctx = new NuxeoController((PortletRequest)resourceRequest, null, this.getPortletContext());
                String id = resourceRequest.getResourceID();
                CMSPublicationInfos pubInfos = ctx.getCMSService().getPublicationInfos(ctx.getCMSCtx(), id);
                StringBuffer sb = new StringBuffer();
                sb.append("<div>");
                int nbItems = 0;
                if (pubInfos.isEditableByUser()) {
                    Document doc = ctx.fetchDocument(id);
                    Map managedTypes = ctx.getDocTypeDefinitions();
                    DocTypeDefinition docTypeDef = (DocTypeDefinition)managedTypes.get(doc.getType());
                    if (docTypeDef != null && docTypeDef.isSupportingPortalForm()) {
                        String refreshUrl = ctx.getPortalUrlFactory().getRefreshPageUrl(new PortalControllerContext(this.getPortletContext(), (PortletRequest)resourceRequest, (PortletResponse)resourceResponse));
                        sb.append("<a class=\"fancyframe_refresh\" onClick=\"setCallbackParams(null, '" + refreshUrl + "')\" href=\"" + ctx.getNuxeoPublicBaseUri() + "/nxpath/default" + pubInfos.getDocumentPath() + "@toutatice_edit\">Modifier</a>");
                        ++nbItems;
                    }
                    if (nbItems > 0) {
                        sb.append("<br/>");
                    }
                    sb.append("<a target=\"nuxeo\" href=\"" + ctx.getNuxeoPublicBaseUri() + "/nxdoc/default/" + pubInfos.getLiveId() + "/view_documents\">Editer dans Nuxeo</a>");
                    ++nbItems;
                }
                if (pubInfos.isDeletableByUser()) {
                    String deleteDivId = resourceResponse.getNamespace() + "delete-file-item";
                    String deleteFormId = resourceResponse.getNamespace() + "delete-file-form";
                    String deleteURL = ctx.getPortalUrlFactory().getPutDocumentInTrashUrl(new PortalControllerContext(this.getPortletContext(), (PortletRequest)resourceRequest, (PortletResponse)resourceResponse), pubInfos.getLiveId(), pubInfos.getDocumentPath());
                    sb.append("<br/>");
                    sb.append("<a class=\"fancybox_inline\" href=\"#" + deleteDivId + "\"");
                    sb.append("onclick=\"document.getElementById('" + deleteFormId + "').action ='" + deleteURL + "';\">");
                    sb.append("Supprimer</a>");
                    ++nbItems;
                }
                if (nbItems == 0) {
                    sb.append("<b>Aucune action<br/>disponible</b>");
                }
                sb.append("<div>");
                resourceResponse.getPortletOutputStream().write(sb.toString().getBytes());
                resourceResponse.getPortletOutputStream().close();
            } else {
                super.serveResource(resourceRequest, resourceResponse);
            }
        }
        catch (NuxeoException e) {
            this.serveResourceException(resourceRequest, resourceResponse, e);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void processAction(ActionRequest req, ActionResponse res) throws IOException, PortletException {
        block5: {
            logger.debug((Object)"processAction ");
            if ("admin".equals(req.getPortletMode().toString()) && req.getParameter("modifierPrefs") != null) {
                PortalWindow window = WindowFactory.getWindow((PortletRequest)req);
                window.setProperty("osivia.nuxeoPath", req.getParameter("nuxeoPath"));
                res.setPortletMode(PortletMode.VIEW);
                res.setWindowState(WindowState.NORMAL);
            }
            if ("admin".equals(req.getPortletMode().toString()) && req.getParameter("annuler") != null) {
                res.setPortletMode(PortletMode.VIEW);
                res.setWindowState(WindowState.NORMAL);
            }
            if (req.getParameter("deleteFileItem") != null) {
                String itemId = req.getParameter("fileItemId");
                NuxeoController ctrl = new NuxeoController((PortletRequest)req, (PortletResponse)res, this.getPortletContext());
                try {
                    ctrl.executeNuxeoCommand((INuxeoCommand)new DeleteDocumentCommand(itemId));
                }
                catch (Exception e) {
                    if (e instanceof PortletException) break block5;
                    throw new PortletException((Throwable)e);
                }
            }
        }
    }

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest req, RenderResponse res) throws IOException, PortletException {
        res.setContentType("text/html");
        NuxeoController ctx = new NuxeoController((PortletRequest)req, (PortletResponse)res, this.getPortletContext());
        PortletRequestDispatcher rd = null;
        PortalWindow window = WindowFactory.getWindow((PortletRequest)req);
        String nuxeoPath = window.getProperty("osivia.nuxeoPath");
        if (nuxeoPath == null) {
            nuxeoPath = "";
        }
        req.setAttribute("nuxeoPath", (Object)nuxeoPath);
        req.setAttribute("ctx", (Object)ctx);
        rd = this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/files/admin.jsp");
        rd.include(req, res);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, PortletSecurityException, IOException {
        block7: {
            logger.debug((Object)"doView");
            try {
                ArrayList sortedDocs;
                Document doc;
                NuxeoController ctx;
                response.setContentType("text/html");
                PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
                String nuxeoPath = null;
                nuxeoPath = window.getProperty("osivia.cms.uri");
                if (nuxeoPath == null) {
                    nuxeoPath = window.getProperty("osivia.nuxeoPath");
                }
                if (nuxeoPath != null) {
                    ctx = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
                    nuxeoPath = ctx.getComputedPath(nuxeoPath);
                    doc = ctx.fetchDocument(nuxeoPath);
                    CMSPublicationInfos pubInfos = ctx.getCMSService().getPublicationInfos(ctx.getCMSCtx(), nuxeoPath);
                    Documents docs = (Documents)ctx.executeNuxeoCommand((INuxeoCommand)new FolderGetFilesCommand(pubInfos.getDocumentPath(), pubInfos.getLiveId()));
                    sortedDocs = (ArrayList)docs.list();
                    if (!FileBrowserPortlet.isOrdered((Document)doc)) {
                        Collections.sort(sortedDocs, FileBrowserPortlet.createComparator((Document)doc));
                    }
                } else {
                    response.setContentType("text/html");
                    response.getWriter().print("<h2>Document non d\u00e9fini</h2>");
                    response.getWriter().close();
                    return;
                }
                request.setAttribute("docs", (Object)sortedDocs);
                ctx.setCurrentDoc(doc);
                ctx.insertContentMenuBarItems();
                request.setAttribute("basePath", (Object)nuxeoPath);
                request.setAttribute("folderPath", (Object)nuxeoPath);
                request.setAttribute("doc", (Object)doc);
                request.setAttribute("ctx", (Object)ctx);
                response.setTitle(doc.getTitle());
                this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/files/view.jsp").include(request, response);
            }
            catch (NuxeoException e) {
                PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
            }
            catch (Exception e) {
                if (e instanceof PortletException) break block7;
                throw new PortletException((Throwable)e);
            }
        }
        logger.debug((Object)"doView end");
    }
}

