/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.service.editablewindow;

import fr.toutatice.portail.cms.nuxeo.service.editablewindow.EditableWindowComparator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.core.cms.CMSException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class EditableWindowHelper {
    public static String SCHEMA = "fgts:fragments";
    public static String FGT_URI = "uri";
    public static String FGT_TYPE = "fragmentCategory";
    public static String FGT_ORDER = "order";
    public static String FGT_REGION = "regionId";
    private static EditableWindowComparator comparator = new EditableWindowComparator();
    protected static final Log logger = LogFactory.getLog(EditableWindowHelper.class);

    private EditableWindowHelper() {
    }

    public static Integer findIndexByURI(Document doc, String refURI) {
        PropertyList list = doc.getProperties().getList(SCHEMA);
        int index = 0;
        for (Object o : list.list()) {
            PropertyMap map;
            if (o instanceof PropertyMap && (refURI.equals((map = (PropertyMap)o).get(FGT_URI)) || refURI.equals(map.get("refURI")))) {
                return index;
            }
            ++index;
        }
        logger.warn((Object)("Fragment " + refURI + " non d\u00e9fini dans le sch\u00e9ma " + SCHEMA));
        return null;
    }

    public static Integer findIndexByRefURI(Document doc, String schema, String refURI) {
        PropertyList list = doc.getProperties().getList(schema);
        int index = 0;
        for (Object o : list.list()) {
            PropertyMap map;
            if (o instanceof PropertyMap && (refURI.equals((map = (PropertyMap)o).get(FGT_URI)) || refURI.equals(map.get("refURI")))) {
                return index;
            }
            ++index;
        }
        logger.warn((Object)("Fragment " + refURI + " non d\u00e9fini dans le sch\u00e9ma " + schema));
        return null;
    }

    public static PropertyMap findSchemaByRefURI(Document doc, String schema, String refURI) {
        PropertyList list = doc.getProperties().getList(schema);
        for (Object o : list.list()) {
            PropertyMap map;
            if (!(o instanceof PropertyMap) || !refURI.equals((map = (PropertyMap)o).get(FGT_URI)) && !refURI.equals(map.get("refURI"))) continue;
            return map;
        }
        logger.warn((Object)("Fragment " + refURI + " non d\u00e9fini dans le sch\u00e9ma " + schema));
        return null;
    }

    public static List<String> checkBeforeMove(Document doc, String fromRegion, Integer fromPos, String refUri) throws CMSException {
        ArrayList<String> propertiesToUpdate = new ArrayList<String>();
        PropertyList list = doc.getProperties().getList(SCHEMA);
        HashMap map = new HashMap();
        for (Object o : list.list()) {
            TreeSet<PropertyMap> currentSet;
            if (!(o instanceof PropertyMap)) continue;
            PropertyMap currentFrag = (PropertyMap)o;
            String currentRegion = currentFrag.getString(FGT_REGION);
            if (map.get(currentRegion) != null) {
                currentSet = (TreeSet<PropertyMap>)map.get(currentRegion);
            } else {
                currentSet = new TreeSet<PropertyMap>((Comparator<PropertyMap>)comparator);
                map.put(currentRegion, currentSet);
            }
            currentSet.add(currentFrag);
        }
        for (SortedSet region : map.values()) {
            Integer expectedOrder = 0;
            for (PropertyMap fragment : region) {
                Integer currentOrder = Integer.parseInt(fragment.getString(FGT_ORDER));
                if (currentOrder != expectedOrder) {
                    Integer fgtToUpdate = EditableWindowHelper.findIndexByURI((Document)doc, (String)fragment.getString(FGT_URI));
                    String moveToOrder = SCHEMA.concat("/").concat(fgtToUpdate.toString()).concat("/").concat(FGT_ORDER).concat("=").concat(expectedOrder.toString());
                    propertiesToUpdate.add(moveToOrder);
                }
                Integer n = expectedOrder;
                Integer n2 = expectedOrder = Integer.valueOf(expectedOrder + 1);
            }
        }
        return propertiesToUpdate;
    }

    public static List<String> prepareMove(Document doc, String fromRegion, Integer fromPos, String toRegion, Integer toPos, String refUri) throws CMSException {
        PropertyMap currentInNuxeo = EditableWindowHelper.findSchemaByRefURI((Document)doc, (String)SCHEMA, (String)refUri);
        if (!currentInNuxeo.getString(FGT_ORDER).equals(Integer.toString(fromPos)) || !currentInNuxeo.getString(FGT_REGION).equals(fromRegion)) {
            throw new CMSException("Document Nux\u00e9o d\u00e9synchronis\u00e9");
        }
        ArrayList<String> propertiesToUpdate = new ArrayList<String>();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("+-------> Move " + refUri + " (" + fromRegion + "/" + fromPos + ") to (" + toRegion + "/" + toPos + ") "));
        }
        if (fromRegion.equals(toRegion) && fromPos.equals(toPos)) {
            return propertiesToUpdate;
        }
        PropertyList list = doc.getProperties().getList(SCHEMA);
        Integer index = 0;
        if (fromRegion.equals(toRegion)) {
            boolean moveDown = true;
            Integer minOrder = fromPos;
            Integer maxOrder = toPos;
            if (fromPos > toPos) {
                moveDown = false;
                minOrder = toPos;
                maxOrder = fromPos;
            }
            for (Object o : list.list()) {
                Integer currentOrder;
                Integer currentFrag;
                if (o instanceof PropertyMap) {
                    currentFrag = (PropertyMap)o;
                    currentOrder = Integer.parseInt(currentFrag.getString(FGT_ORDER));
                    if (fromRegion.equals(currentFrag.getString(FGT_REGION))) {
                        String moveToOrder;
                        Integer newOrder;
                        if (fromPos.equals(currentOrder)) {
                            newOrder = toPos;
                            moveToOrder = SCHEMA.concat("/").concat(index.toString()).concat("/").concat(FGT_ORDER).concat("=").concat(newOrder.toString());
                            propertiesToUpdate.add(moveToOrder);
                        } else if (fromRegion.equals(currentFrag.getString(FGT_REGION)) && currentOrder >= minOrder && currentOrder <= maxOrder) {
                            newOrder = moveDown ? currentOrder - 1 : currentOrder + 1;
                            moveToOrder = SCHEMA.concat("/").concat(index.toString()).concat("/").concat(FGT_ORDER).concat("=").concat(newOrder.toString());
                            propertiesToUpdate.add(moveToOrder);
                        }
                    }
                }
                currentFrag = index;
                currentOrder = index = Integer.valueOf(index + 1);
            }
        } else {
            for (Object o : list.list()) {
                if (o instanceof PropertyMap) {
                    PropertyMap currentFrag = (PropertyMap)o;
                    Integer currentOrder = Integer.parseInt(currentFrag.getString(FGT_ORDER));
                    if (fromRegion.equals(currentFrag.getString(FGT_REGION)) && fromPos.equals(currentOrder)) {
                        String moveToRegion = SCHEMA.concat("/").concat(index.toString()).concat("/").concat(FGT_REGION).concat("=").concat(toRegion);
                        propertiesToUpdate.add(moveToRegion);
                        Integer newOrder = toPos;
                        String moveToOrder = SCHEMA.concat("/").concat(index.toString()).concat("/").concat(FGT_ORDER).concat("=").concat(newOrder.toString());
                        propertiesToUpdate.add(moveToOrder);
                    } else {
                        String moveToOrder;
                        Integer newOrder;
                        if (fromRegion.equals(currentFrag.getString(FGT_REGION)) && currentOrder > fromPos) {
                            newOrder = currentOrder - 1;
                            moveToOrder = SCHEMA.concat("/").concat(index.toString()).concat("/").concat(FGT_ORDER).concat("=").concat(newOrder.toString());
                            propertiesToUpdate.add(moveToOrder);
                        }
                        if (toRegion.equals(currentFrag.getString(FGT_REGION)) && currentOrder >= toPos) {
                            newOrder = currentOrder + 1;
                            moveToOrder = SCHEMA.concat("/").concat(index.toString()).concat("/").concat(FGT_ORDER).concat("=").concat(newOrder.toString());
                            propertiesToUpdate.add(moveToOrder);
                        }
                    }
                }
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
        }
        return propertiesToUpdate;
    }
}

