/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.service.editablewindow;

import fr.toutatice.portail.cms.nuxeo.service.editablewindow.EditableWindow;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.EditableWindowHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListEditableWindow
extends EditableWindow {
    private static final String LISTSCHEMA = "listfgt:listFragment";
    private static final String NEWSSCHEMA = "nwslk:links";

    public ListEditableWindow(String instancePortlet, String prefixWindow) {
        super(instancePortlet, prefixWindow);
    }

    public Map<String, String> fillProps(Document doc, PropertyMap fragment, Boolean modeEditionPage) {
        Map props = super.fillGenericProps(doc, fragment, modeEditionPage);
        PropertyMap mapListe = EditableWindowHelper.findSchemaByRefURI((Document)doc, (String)LISTSCHEMA, (String)fragment.getString("uri"));
        props.put("osivia.nuxeoRequest", mapListe.getString("request"));
        props.put("osivia.requestInterpretor", "beanShell");
        props.put("osivia.cms.scope", null);
        props.put("osivia.displayNuxeoRequest", null);
        props.put("osivia.cms.requestFilteringPolicy", null);
        props.put("osivia.cms.hideMetaDatas", null);
        if (mapListe.getBoolean("allContents").booleanValue()) {
            props.put("osivia.cms.requestFilteringPolicy", "global");
            props.put("osivia.cms.displayLiveVersion", "1");
        } else {
            props.put("osivia.cms.requestFilteringPolicy", null);
            props.put("osivia.cms.displayLiveVersion", null);
        }
        props.put("osivia.cms.style", mapListe.getString("view"));
        props.put("osivia.cms.pageSize", mapListe.getString("pageSize"));
        props.put("osivia.cms.pageSizeMax", mapListe.getString("pageSizeMax"));
        props.put("osivia.cms.maxItems", mapListe.getString("maxItems"));
        props.put("osivia.permaLinkRef", null);
        props.put("osivia.rssLinkRef", null);
        props.put("osivia.rssTitle", null);
        props.put("osivia.cms.feed", mapListe.getString("feed"));
        if ("true".equals(mapListe.getString("feed"))) {
            this.fillFeedProps(doc, fragment, props, mapListe);
        }
        return props;
    }

    private void fillFeedProps(Document doc, PropertyMap fragment, Map<String, String> props, PropertyMap mapListe) {
        PropertyList newslinks = doc.getProperties().getList(NEWSSCHEMA);
        boolean nbElements = false;
        Integer i = 0;
        for (Object news : newslinks.list()) {
            PropertyMap mapNews;
            if (!(news instanceof PropertyMap) || !(mapNews = (PropertyMap)news).getString("refURI").equals(fragment.get("uri"))) continue;
            props.put("osivia.cms.news." + i.toString() + ".docURI", mapNews.getString("documentURI"));
            props.put("osivia.cms.news." + i.toString() + ".order", mapNews.getString("order"));
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        props.put("osivia.cms.news.size", Integer.toString(i));
    }

    public List<String> prepareDelete(Document doc, String refURI) {
        ArrayList<String> propertiesToRemove = new ArrayList<String>();
        this.prepareDeleteGeneric(propertiesToRemove, doc, refURI);
        Integer indexToRemove = EditableWindowHelper.findIndexByRefURI((Document)doc, (String)LISTSCHEMA, (String)refURI);
        propertiesToRemove.add(LISTSCHEMA.concat("/").concat(indexToRemove.toString()));
        return propertiesToRemove;
    }
}

