/*
 * Decompiled with CFR 0.152.
 */
package com.osivia.portail.site.portlets.utils;

import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Pattern;

public final class StringHelper {
    private static HashMap<String, Integer> htmlEntities = new HashMap();

    private StringHelper() {
    }

    public static String prepad(String s, int length) {
        return StringHelper.prepad(s, length, ' ');
    }

    public static String prepad(String s, int length, char c) {
        int needed = length - s.length();
        if (needed <= 0) {
            return s;
        }
        char[] padding = new char[needed];
        Arrays.fill(padding, c);
        StringBuffer sb = new StringBuffer(length);
        sb.append(padding);
        sb.append(s);
        return sb.toString();
    }

    public static String postpad(String s, int length) {
        return StringHelper.postpad(s, length, ' ');
    }

    public static String postpad(String s, int length, char c) {
        int needed = length - s.length();
        if (needed <= 0) {
            return s;
        }
        char[] padding = new char[needed];
        Arrays.fill(padding, c);
        StringBuffer sb = new StringBuffer(length);
        sb.append(s);
        sb.append(padding);
        return sb.toString();
    }

    public static String midpad(String s, int length) {
        return StringHelper.midpad(s, length, ' ');
    }

    public static String midpad(String s, int length, char c) {
        int needed = length - s.length();
        if (needed <= 0) {
            return s;
        }
        int beginning = needed / 2;
        int end = beginning + needed % 2;
        char[] prepadding = new char[beginning];
        Arrays.fill(prepadding, c);
        char[] postpadding = new char[end];
        Arrays.fill(postpadding, c);
        StringBuffer sb = new StringBuffer(length);
        sb.append(prepadding);
        sb.append(s);
        sb.append(postpadding);
        return sb.toString();
    }

    public static String[] split(String s, String delimiter) {
        int end;
        int stringLength = s.length();
        if (delimiter == null || delimiter.length() == 0) {
            return new String[]{s};
        }
        int delimiterLength = delimiter.length();
        int count = 0;
        int start = 0;
        while ((end = s.indexOf(delimiter, start)) != -1) {
            ++count;
            start = end + delimiterLength;
        }
        String[] result = new String[++count];
        count = 0;
        start = 0;
        while ((end = s.indexOf(delimiter, start)) != -1) {
            result[count] = s.substring(start, end);
            ++count;
            start = end + delimiterLength;
        }
        end = stringLength;
        result[count] = s.substring(start, end);
        return result;
    }

    public static String[] splitIncludeDelimiters(String s, String delimiter) {
        int end;
        int stringLength = s.length();
        if (delimiter == null || delimiter.length() == 0) {
            return new String[]{s};
        }
        int delimiterLength = delimiter.length();
        int count = 0;
        int start = 0;
        while ((end = s.indexOf(delimiter, start)) != -1) {
            count += 2;
            start = end + delimiterLength;
        }
        String[] result = new String[++count];
        count = 0;
        start = 0;
        while ((end = s.indexOf(delimiter, start)) != -1) {
            result[count] = s.substring(start, end);
            result[++count] = delimiter;
            ++count;
            start = end + delimiterLength;
        }
        end = stringLength;
        result[count] = s.substring(start, end);
        return result;
    }

    public static String join(String[] array) {
        return StringHelper.join(array, "");
    }

    public static String join(String[] array, String delimiter) {
        int delimiterLength = delimiter.length();
        if (array.length == 0) {
            return "";
        }
        if (array.length == 1) {
            if (array[0] == null) {
                return "";
            }
            return array[0];
        }
        int length = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) {
                length += array[i].length();
            }
            if (i >= array.length - 1) continue;
            length += delimiterLength;
        }
        StringBuffer result = new StringBuffer(length);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) {
                result.append(array[i]);
            }
            if (i >= array.length - 1) continue;
            result.append(delimiter);
        }
        return result.toString();
    }

    public static String replace(String s, String find, String replace) {
        int length;
        int replaceLength;
        int stringLength = s.length();
        if (find == null || find.length() == 0) {
            return s;
        }
        int findLength = find.length();
        if (replace == null) {
            replace = "";
        }
        if (findLength == (replaceLength = replace.length())) {
            length = stringLength;
        } else {
            int end;
            int count = 0;
            int start = 0;
            while ((end = s.indexOf(find, start)) != -1) {
                ++count;
                start = end + findLength;
            }
            if (count == 0) {
                return s;
            }
            length = stringLength - count * (findLength - replaceLength);
        }
        int start = 0;
        int end = s.indexOf(find, start);
        if (end == -1) {
            return s;
        }
        StringBuffer sb = new StringBuffer(length);
        while (end != -1) {
            sb.append(s.substring(start, end));
            sb.append(replace);
            start = end + findLength;
            end = s.indexOf(find, start);
        }
        end = stringLength;
        sb.append(s.substring(start, end));
        return sb.toString();
    }

    public static String escapeHTML(String s) {
        int length;
        int newLength = length = s.length();
        boolean someCharacterEscaped = false;
        block19: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            int cint = 0xFFFF & c;
            if (cint < 32) {
                switch (c) {
                    case '\t': 
                    case '\f': {
                        break;
                    }
                    default: {
                        --newLength;
                        someCharacterEscaped = true;
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case '\"': {
                    newLength += 5;
                    someCharacterEscaped = true;
                    continue block19;
                }
                case '&': 
                case '\'': {
                    newLength += 4;
                    someCharacterEscaped = true;
                    continue block19;
                }
                case '<': 
                case '>': {
                    newLength += 3;
                    someCharacterEscaped = true;
                }
            }
        }
        if (!someCharacterEscaped) {
            return s;
        }
        StringBuffer sb = new StringBuffer(newLength);
        block20: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            int cint = 0xFFFF & c;
            if (cint < 32) {
                switch (c) {
                    case '\t': 
                    case '\f': 
                    case '\r': {
                        sb.append(c);
                        break;
                    }
                    case '\n': {
                        sb.append("<br/>");
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case '\"': {
                    sb.append("&quot;");
                    continue block20;
                }
                case '\'': {
                    sb.append("&#39;");
                    continue block20;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block20;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block20;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block20;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String escapeSQL(String s) throws NullPointerException {
        int length;
        int newLength = length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\u0000': 
                case '\"': 
                case '\'': 
                case '\\': {
                    ++newLength;
                }
            }
        }
        if (length == newLength) {
            return s;
        }
        StringBuffer sb = new StringBuffer(newLength);
        block10: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block10;
                }
                case '\u0000': {
                    sb.append("\\0");
                    continue block10;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String escapeJavaLiteral(String s) throws NullPointerException {
        int length;
        int newLength = length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case '\"': 
                case '\'': 
                case '\\': {
                    ++newLength;
                }
            }
        }
        if (length == newLength) {
            return s;
        }
        StringBuffer sb = new StringBuffer(newLength);
        block12: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block12;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block12;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block12;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block12;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block12;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block12;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String trim(String s, String c) throws NullPointerException {
        int j;
        char ch;
        int i;
        int length = s.length();
        if (c == null) {
            return s;
        }
        int cLength = c.length();
        if (c.length() == 0) {
            return s;
        }
        int start = 0;
        int end = length;
        boolean found = false;
        for (i = 0; !found && i < length; ++i) {
            ch = s.charAt(i);
            found = true;
            for (j = 0; found && j < cLength; ++j) {
                if (c.charAt(j) != ch) continue;
                found = false;
            }
        }
        if (!found) {
            return "";
        }
        start = i - 1;
        found = false;
        for (i = length - 1; !found && i >= 0; --i) {
            ch = s.charAt(i);
            found = true;
            for (j = 0; found && j < cLength; ++j) {
                if (c.charAt(j) != ch) continue;
                found = false;
            }
        }
        end = i + 2;
        return s.substring(start, end);
    }

    public static String unescapeHTML(String s) throws NullPointerException {
        StringBuffer result = new StringBuffer(s.length());
        int ampInd = s.indexOf("&");
        int lastEnd = 0;
        while (ampInd >= 0) {
            int nextAmp = s.indexOf("&", ampInd + 1);
            int nextSemi = s.indexOf(";", ampInd + 1);
            if (nextSemi != -1 && (nextAmp == -1 || nextSemi < nextAmp)) {
                int value = -1;
                String escape = s.substring(ampInd + 1, nextSemi);
                try {
                    if (escape.startsWith("#")) {
                        value = Integer.parseInt(escape.substring(1), 10);
                    } else if (htmlEntities.containsKey(escape)) {
                        value = htmlEntities.get(escape);
                    }
                }
                catch (NumberFormatException x) {
                    // empty catch block
                }
                result.append(s.substring(lastEnd, ampInd));
                lastEnd = nextSemi + 1;
                if (value >= 0 && value <= 65535) {
                    result.append((char)value);
                } else {
                    result.append("&").append(escape).append(";");
                }
            }
            ampInd = nextAmp;
        }
        result.append(s.substring(lastEnd));
        return result.toString();
    }

    public static String escapeRegularExpressionLiteral(String s) throws NullPointerException {
        int length;
        int newLength = length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') continue;
            ++newLength;
        }
        if (length == newLength) {
            return s;
        }
        StringBuffer sb = new StringBuffer(newLength);
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static void buildFindAnyPattern(String[] terms, StringBuffer sb) throws IllegalArgumentException {
        if (terms.length == 0) {
            throw new IllegalArgumentException("There must be at least one term to find.");
        }
        sb.append("(?:");
        for (int i = 0; i < terms.length; ++i) {
            if (i > 0) {
                sb.append("|");
            }
            sb.append("(?:");
            sb.append(StringHelper.escapeRegularExpressionLiteral(terms[i]));
            sb.append(")");
        }
        sb.append(")");
    }

    public static Pattern getContainsAnyPattern(String[] terms) {
        StringBuffer sb = new StringBuffer();
        sb.append("(?s).*");
        StringHelper.buildFindAnyPattern(terms, sb);
        sb.append(".*");
        return Pattern.compile(sb.toString());
    }

    public static Pattern getEqualsAnyPattern(String[] terms) {
        StringBuffer sb = new StringBuffer();
        sb.append("(?s)\\A");
        StringHelper.buildFindAnyPattern(terms, sb);
        sb.append("\\z");
        return Pattern.compile(sb.toString());
    }

    public static Pattern getStartsWithAnyPattern(String[] terms) {
        StringBuffer sb = new StringBuffer();
        sb.append("(?s)\\A");
        StringHelper.buildFindAnyPattern(terms, sb);
        sb.append(".*");
        return Pattern.compile(sb.toString());
    }

    public static Pattern getEndsWithAnyPattern(String[] terms) {
        StringBuffer sb = new StringBuffer();
        sb.append("(?s).*");
        StringHelper.buildFindAnyPattern(terms, sb);
        sb.append("\\z");
        return Pattern.compile(sb.toString());
    }

    public static Pattern getContainsAnyIgnoreCasePattern(String[] terms) {
        StringBuffer sb = new StringBuffer();
        sb.append("(?i)(?u)(?s).*");
        StringHelper.buildFindAnyPattern(terms, sb);
        sb.append(".*");
        return Pattern.compile(sb.toString());
    }

    public static Pattern getEqualsAnyIgnoreCasePattern(String[] terms) {
        StringBuffer sb = new StringBuffer();
        sb.append("(?i)(?u)(?s)\\A");
        StringHelper.buildFindAnyPattern(terms, sb);
        sb.append("\\z");
        return Pattern.compile(sb.toString());
    }

    public static Pattern getStartsWithAnyIgnoreCasePattern(String[] terms) {
        StringBuffer sb = new StringBuffer();
        sb.append("(?i)(?u)(?s)\\A");
        StringHelper.buildFindAnyPattern(terms, sb);
        sb.append(".*");
        return Pattern.compile(sb.toString());
    }

    public static Pattern getEndsWithAnyIgnoreCasePattern(String[] terms) {
        StringBuffer sb = new StringBuffer();
        sb.append("(?i)(?u)(?s).*");
        StringHelper.buildFindAnyPattern(terms, sb);
        sb.append("\\z");
        return Pattern.compile(sb.toString());
    }

    public static boolean containsAny(String s, String[] terms) {
        return StringHelper.getContainsAnyPattern(terms).matcher(s).matches();
    }

    public static boolean equalsAny(String s, String[] terms) {
        return StringHelper.getEqualsAnyPattern(terms).matcher(s).matches();
    }

    public static boolean startsWithAny(String s, String[] terms) {
        return StringHelper.getStartsWithAnyPattern(terms).matcher(s).matches();
    }

    public static boolean endsWithAny(String s, String[] terms) {
        return StringHelper.getEndsWithAnyPattern(terms).matcher(s).matches();
    }

    public static boolean containsAnyIgnoreCase(String s, String[] terms) {
        return StringHelper.getContainsAnyIgnoreCasePattern(terms).matcher(s).matches();
    }

    public static boolean equalsAnyIgnoreCase(String s, String[] terms) {
        return StringHelper.getEqualsAnyIgnoreCasePattern(terms).matcher(s).matches();
    }

    public static boolean startsWithAnyIgnoreCase(String s, String[] terms) {
        return StringHelper.getStartsWithAnyIgnoreCasePattern(terms).matcher(s).matches();
    }

    public static boolean endsWithAnyIgnoreCase(String s, String[] terms) {
        return StringHelper.getEndsWithAnyIgnoreCasePattern(terms).matcher(s).matches();
    }

    public static String formatText(String text, boolean printLineFeeds) throws ParseException {
        if (text == null) {
            return "";
        }
        String output = text;
        if (!printLineFeeds) {
            output = output.replaceAll("\n", " ");
            output = output.replaceAll("\r", " ");
        }
        return StringHelper.escapeHTML(output);
    }

    static {
        htmlEntities.put("nbsp", 160);
        htmlEntities.put("iexcl", 161);
        htmlEntities.put("cent", 162);
        htmlEntities.put("pound", 163);
        htmlEntities.put("curren", 164);
        htmlEntities.put("yen", 165);
        htmlEntities.put("brvbar", 166);
        htmlEntities.put("sect", 167);
        htmlEntities.put("uml", 168);
        htmlEntities.put("copy", 169);
        htmlEntities.put("ordf", 170);
        htmlEntities.put("laquo", 171);
        htmlEntities.put("not", 172);
        htmlEntities.put("shy", 173);
        htmlEntities.put("reg", 174);
        htmlEntities.put("macr", 175);
        htmlEntities.put("deg", 176);
        htmlEntities.put("plusmn", 177);
        htmlEntities.put("sup2", 178);
        htmlEntities.put("sup3", 179);
        htmlEntities.put("acute", 180);
        htmlEntities.put("micro", 181);
        htmlEntities.put("para", 182);
        htmlEntities.put("middot", 183);
        htmlEntities.put("cedil", 184);
        htmlEntities.put("sup1", 185);
        htmlEntities.put("ordm", 186);
        htmlEntities.put("raquo", 187);
        htmlEntities.put("frac14", 188);
        htmlEntities.put("frac12", 189);
        htmlEntities.put("frac34", 190);
        htmlEntities.put("iquest", 191);
        htmlEntities.put("Agrave", 192);
        htmlEntities.put("Aacute", 193);
        htmlEntities.put("Acirc", 194);
        htmlEntities.put("Atilde", 195);
        htmlEntities.put("Auml", 196);
        htmlEntities.put("Aring", 197);
        htmlEntities.put("AElig", 198);
        htmlEntities.put("Ccedil", 199);
        htmlEntities.put("Egrave", 200);
        htmlEntities.put("Eacute", 201);
        htmlEntities.put("Ecirc", 202);
        htmlEntities.put("Euml", 203);
        htmlEntities.put("Igrave", 204);
        htmlEntities.put("Iacute", 205);
        htmlEntities.put("Icirc", 206);
        htmlEntities.put("Iuml", 207);
        htmlEntities.put("ETH", 208);
        htmlEntities.put("Ntilde", 209);
        htmlEntities.put("Ograve", 210);
        htmlEntities.put("Oacute", 211);
        htmlEntities.put("Ocirc", 212);
        htmlEntities.put("Otilde", 213);
        htmlEntities.put("Ouml", 214);
        htmlEntities.put("times", 215);
        htmlEntities.put("Oslash", 216);
        htmlEntities.put("Ugrave", 217);
        htmlEntities.put("Uacute", 218);
        htmlEntities.put("Ucirc", 219);
        htmlEntities.put("Uuml", 220);
        htmlEntities.put("Yacute", 221);
        htmlEntities.put("THORN", 222);
        htmlEntities.put("szlig", 223);
        htmlEntities.put("agrave", 224);
        htmlEntities.put("aacute", 225);
        htmlEntities.put("acirc", 226);
        htmlEntities.put("atilde", 227);
        htmlEntities.put("auml", 228);
        htmlEntities.put("aring", 229);
        htmlEntities.put("aelig", 230);
        htmlEntities.put("ccedil", 231);
        htmlEntities.put("egrave", 232);
        htmlEntities.put("eacute", 233);
        htmlEntities.put("ecirc", 234);
        htmlEntities.put("euml", 235);
        htmlEntities.put("igrave", 236);
        htmlEntities.put("iacute", 237);
        htmlEntities.put("icirc", 238);
        htmlEntities.put("iuml", 239);
        htmlEntities.put("eth", 240);
        htmlEntities.put("ntilde", 241);
        htmlEntities.put("ograve", 242);
        htmlEntities.put("oacute", 243);
        htmlEntities.put("ocirc", 244);
        htmlEntities.put("otilde", 245);
        htmlEntities.put("ouml", 246);
        htmlEntities.put("divide", 247);
        htmlEntities.put("oslash", 248);
        htmlEntities.put("ugrave", 249);
        htmlEntities.put("uacute", 250);
        htmlEntities.put("ucirc", 251);
        htmlEntities.put("uuml", 252);
        htmlEntities.put("yacute", 253);
        htmlEntities.put("thorn", 254);
        htmlEntities.put("yuml", 255);
        htmlEntities.put("fnof", 402);
        htmlEntities.put("Alpha", 913);
        htmlEntities.put("Beta", 914);
        htmlEntities.put("Gamma", 915);
        htmlEntities.put("Delta", 916);
        htmlEntities.put("Epsilon", 917);
        htmlEntities.put("Zeta", 918);
        htmlEntities.put("Eta", 919);
        htmlEntities.put("Theta", 920);
        htmlEntities.put("Iota", 921);
        htmlEntities.put("Kappa", 922);
        htmlEntities.put("Lambda", 923);
        htmlEntities.put("Mu", 924);
        htmlEntities.put("Nu", 925);
        htmlEntities.put("Xi", 926);
        htmlEntities.put("Omicron", 927);
        htmlEntities.put("Pi", 928);
        htmlEntities.put("Rho", 929);
        htmlEntities.put("Sigma", 931);
        htmlEntities.put("Tau", 932);
        htmlEntities.put("Upsilon", 933);
        htmlEntities.put("Phi", 934);
        htmlEntities.put("Chi", 935);
        htmlEntities.put("Psi", 936);
        htmlEntities.put("Omega", 937);
        htmlEntities.put("alpha", 945);
        htmlEntities.put("beta", 946);
        htmlEntities.put("gamma", 947);
        htmlEntities.put("delta", 948);
        htmlEntities.put("epsilon", 949);
        htmlEntities.put("zeta", 950);
        htmlEntities.put("eta", 951);
        htmlEntities.put("theta", 952);
        htmlEntities.put("iota", 953);
        htmlEntities.put("kappa", 954);
        htmlEntities.put("lambda", 955);
        htmlEntities.put("mu", 956);
        htmlEntities.put("nu", 957);
        htmlEntities.put("xi", 958);
        htmlEntities.put("omicron", 959);
        htmlEntities.put("pi", 960);
        htmlEntities.put("rho", 961);
        htmlEntities.put("sigmaf", 962);
        htmlEntities.put("sigma", 963);
        htmlEntities.put("tau", 964);
        htmlEntities.put("upsilon", 965);
        htmlEntities.put("phi", 966);
        htmlEntities.put("chi", 967);
        htmlEntities.put("psi", 968);
        htmlEntities.put("omega", 969);
        htmlEntities.put("thetasym", 977);
        htmlEntities.put("upsih", 978);
        htmlEntities.put("piv", 982);
        htmlEntities.put("bull", 8226);
        htmlEntities.put("hellip", 8230);
        htmlEntities.put("prime", 8242);
        htmlEntities.put("Prime", 8243);
        htmlEntities.put("oline", 8254);
        htmlEntities.put("frasl", 8260);
        htmlEntities.put("weierp", 8472);
        htmlEntities.put("image", 8465);
        htmlEntities.put("real", 8476);
        htmlEntities.put("trade", 8482);
        htmlEntities.put("alefsym", 8501);
        htmlEntities.put("larr", 8592);
        htmlEntities.put("uarr", 8593);
        htmlEntities.put("rarr", 8594);
        htmlEntities.put("darr", 8595);
        htmlEntities.put("harr", 8596);
        htmlEntities.put("crarr", 8629);
        htmlEntities.put("lArr", 8656);
        htmlEntities.put("uArr", 8657);
        htmlEntities.put("rArr", 8658);
        htmlEntities.put("dArr", 8659);
        htmlEntities.put("hArr", 8660);
        htmlEntities.put("forall", 8704);
        htmlEntities.put("part", 8706);
        htmlEntities.put("exist", 8707);
        htmlEntities.put("empty", 8709);
        htmlEntities.put("nabla", 8711);
        htmlEntities.put("isin", 8712);
        htmlEntities.put("notin", 8713);
        htmlEntities.put("ni", 8715);
        htmlEntities.put("prod", 8719);
        htmlEntities.put("sum", 8721);
        htmlEntities.put("minus", 8722);
        htmlEntities.put("lowast", 8727);
        htmlEntities.put("radic", 8730);
        htmlEntities.put("prop", 8733);
        htmlEntities.put("infin", 8734);
        htmlEntities.put("ang", 8736);
        htmlEntities.put("and", 8743);
        htmlEntities.put("or", 8744);
        htmlEntities.put("cap", 8745);
        htmlEntities.put("cup", 8746);
        htmlEntities.put("int", 8747);
        htmlEntities.put("there4", 8756);
        htmlEntities.put("sim", 8764);
        htmlEntities.put("cong", 8773);
        htmlEntities.put("asymp", 8776);
        htmlEntities.put("ne", 8800);
        htmlEntities.put("equiv", 8801);
        htmlEntities.put("le", 8804);
        htmlEntities.put("ge", 8805);
        htmlEntities.put("sub", 8834);
        htmlEntities.put("sup", 8835);
        htmlEntities.put("nsub", 8836);
        htmlEntities.put("sube", 8838);
        htmlEntities.put("supe", 8839);
        htmlEntities.put("oplus", 8853);
        htmlEntities.put("otimes", 8855);
        htmlEntities.put("perp", 8869);
        htmlEntities.put("sdot", 8901);
        htmlEntities.put("lceil", 8968);
        htmlEntities.put("rceil", 8969);
        htmlEntities.put("lfloor", 8970);
        htmlEntities.put("rfloor", 8971);
        htmlEntities.put("lang", 9001);
        htmlEntities.put("rang", 9002);
        htmlEntities.put("loz", 9674);
        htmlEntities.put("spades", 9824);
        htmlEntities.put("clubs", 9827);
        htmlEntities.put("hearts", 9829);
        htmlEntities.put("diams", 9830);
        htmlEntities.put("quot", 34);
        htmlEntities.put("amp", 38);
        htmlEntities.put("lt", 60);
        htmlEntities.put("gt", 62);
        htmlEntities.put("OElig", 338);
        htmlEntities.put("oelig", 339);
        htmlEntities.put("Scaron", 352);
        htmlEntities.put("scaron", 353);
        htmlEntities.put("Yuml", 376);
        htmlEntities.put("circ", 710);
        htmlEntities.put("tilde", 732);
        htmlEntities.put("ensp", 8194);
        htmlEntities.put("emsp", 8195);
        htmlEntities.put("thinsp", 8201);
        htmlEntities.put("zwnj", 8204);
        htmlEntities.put("zwj", 8205);
        htmlEntities.put("lrm", 8206);
        htmlEntities.put("rlm", 8207);
        htmlEntities.put("ndash", 8211);
        htmlEntities.put("mdash", 8212);
        htmlEntities.put("lsquo", 8216);
        htmlEntities.put("rsquo", 8217);
        htmlEntities.put("sbquo", 8218);
        htmlEntities.put("ldquo", 8220);
        htmlEntities.put("rdquo", 8221);
        htmlEntities.put("bdquo", 8222);
        htmlEntities.put("dagger", 8224);
        htmlEntities.put("Dagger", 8225);
        htmlEntities.put("permil", 8240);
        htmlEntities.put("lsaquo", 8249);
        htmlEntities.put("rsaquo", 8250);
        htmlEntities.put("euro", 8364);
    }
}

