/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.collab.tools.room.listener;

import fr.toutatice.ecm.platform.core.query.helper.ToutaticeQueryHelper;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.EventImpl;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.webengine.sites.listeners.SiteActionListener;

public class InheritSiteActionListener
extends SiteActionListener {
    private static final String REPO_WEBCURL_UNICITY_QUERY = "select * from Document where webc:url = '%s' and ecm:isVersion = 0 and ecm:isProxy = 0";
    private static final String INCREMENT_PREFIX = "_";

    public void handleEvent(Event event) throws ClientException {
        if ("aboutToCreate".equals(event.getName())) {
            DocumentEventContext docContext;
            DocumentModel sourceDocument;
            SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
            EventContext eventContext = event.getContext();
            if (eventContext instanceof DocumentEventContext && schemaManager.hasSuperType((sourceDocument = (docContext = (DocumentEventContext)eventContext).getSourceDocument()).getType(), "Workspace")) {
                String parentPath = null;
                DocumentModelImpl virtualWs = new DocumentModelImpl(parentPath, sourceDocument.getName(), "Workspace");
                DocumentEventContext virtualDocCtx = new DocumentEventContext(sourceDocument.getCoreSession(), docContext.getPrincipal(), (DocumentModel)virtualWs);
                EventImpl virtualEvent = new EventImpl("aboutToCreate", (EventContext)virtualDocCtx);
                super.handleEvent((Event)virtualEvent);
                DocumentModel virtualWsModified = ((DocumentEventContext)virtualEvent.getContext()).getSourceDocument();
                String webcUrl = (String)((Object)virtualWsModified.getPropertyValue("webc:url"));
                while (this.isNotUnique(sourceDocument.getCoreSession(), webcUrl)) {
                    webcUrl = this.generateWebcUrl(webcUrl);
                }
                String webcName = (String)((Object)virtualWsModified.getPropertyValue("webc:name"));
                sourceDocument.setPropertyValue("webc:name", (Serializable)((Object)webcName));
                sourceDocument.setPropertyValue("webc:url", (Serializable)((Object)webcUrl));
            }
        } else {
            super.handleEvent(event);
        }
    }

    private boolean isNotUnique(CoreSession session, String webcUrl) {
        return ToutaticeQueryHelper.queryUnrestricted((CoreSession)session, (String)String.format(REPO_WEBCURL_UNICITY_QUERY, webcUrl)).size() >= 1;
    }

    private String generateWebcUrl(String webcUrl) {
        String increment = StringUtils.substringAfterLast((String)webcUrl, (String)INCREMENT_PREFIX);
        if (StringUtils.isNotBlank((String)increment)) {
            int incr = Integer.valueOf(increment) + 1;
            webcUrl = StringUtils.substringBeforeLast((String)webcUrl, (String)INCREMENT_PREFIX).concat(INCREMENT_PREFIX).concat(String.valueOf(incr));
        } else {
            webcUrl = webcUrl.concat(INCREMENT_PREFIX).concat(String.valueOf(1));
        }
        return webcUrl;
    }
}

