/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.addon.shortname.generators;

import fr.toutatice.ecm.acrennes.addon.shortname.service.ShortNameMgtService;
import fr.toutatice.ecm.acrennes.addon.shortname.service.ShortNameMgtServiceDescriptor;
import fr.toutatice.ecm.acrennes.addon.shortname.service.ShortNameValidationDescriptor;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDirectoryMngtHelper;
import fr.toutatice.ecm.platform.core.utils.exception.ToutaticeException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.uidgen.AbstractUIDGenerator;
import org.nuxeo.runtime.api.Framework;

public class ShortNameGenerator
extends AbstractUIDGenerator {
    private static final Log log = LogFactory.getLog(ShortNameGenerator.class);
    private int maxShortNameSize = Integer.parseInt(Framework.getProperty((String)"acrennes.shortname.raw.maxsize", (String)"50"));
    private ShortNameMgtService snService;

    public String getSequenceKey(DocumentModel document) throws DocumentException {
        return "SHORTNAME";
    }

    public String createUID(DocumentModel document) throws DocumentException {
        String shortName = null;
        try {
            ShortNameMgtServiceDescriptor policy = this.getSNService().getPolicy(document);
            if (null != policy) {
                String currentValue = (String)((Object)document.getPropertyValue("acr:shortName"));
                if (StringUtils.isNotBlank((String)currentValue)) {
                    log.warn((Object)("The current value of the shortname metada ('" + currentValue + "') is about to be overriden for the document '" + document.getPathAsString() + "'"));
                }
                ShortNameIterator snItr = new ShortNameIterator(document);
                while (null == shortName && snItr.hasNext()) {
                    String sn = (String)snItr.next();
                    HashMap<String, String> presetArgs = new HashMap<String, String>();
                    presetArgs.put("acr:shortName", sn);
                    String namingRule = this.getSNService().getGroupeNamingRule(document, presetArgs);
                    ShortNameValidationDescriptor validation = policy.getValidation();
                    DocumentModelList items = ToutaticeDirectoryMngtHelper.instance().getItems(validation.getDirectory(), validation.getAttribute(), namingRule);
                    if (null != items && !items.isEmpty()) continue;
                    shortName = sn;
                    log.info((Object)("shortname '" + shortName + "' is set to the document '" + document.getPathAsString() + "'"));
                }
                if (null == shortName) {
                    log.warn((Object)("Failed to build a short name for the current document '" + document.getPathAsString() + "' (all attempts failed)"));
                }
            } else {
                log.info((Object)("missing policy for document type '" + document.getType() + "' "));
            }
        }
        catch (Exception e) {
            log.warn((Object)("Failed to build a short name for the current document '" + document.getPathAsString() + "', error: " + e.getMessage()));
            shortName = null;
        }
        return shortName;
    }

    private ShortNameMgtService getSNService() throws ToutaticeException {
        if (null == this.snService) {
            this.snService = (ShortNameMgtService)Framework.getLocalService(ShortNameMgtService.class);
            if (null == this.snService) {
                throw new ToutaticeException("Failed to obtain the short name service");
            }
        }
        return this.snService;
    }

    private class ShortNameIterator
    implements Iterator<String> {
        private static final int MAX_ATTEMPTS_NBR = 1000;
        private String rawShortName;
        private PageProviderService ppService;
        private List<Integer> itrList = new ArrayList<Integer>();
        private int itrCount = 0;
        private int next = 0;
        private static final String PAGE_PROVIDER_NAME = "GET_SIMILAR_SHORTNAME";

        public ShortNameIterator(DocumentModel document) throws ToutaticeException {
            this.rawShortName = this.generateShortName(document);
            List<DocumentModel> uList = this.getSimilarShortNamesList(document.getCoreSession(), this.rawShortName + "%");
            if (null != uList && 0 < uList.size()) {
                Pattern p = Pattern.compile(this.rawShortName + "(\\d*)$");
                for (DocumentModel doc : uList) {
                    Matcher m;
                    String sn = (String)((Object)doc.getPropertyValue("acr:shortName"));
                    if (!StringUtils.isNotBlank((String)sn) || !(m = p.matcher(sn)).matches()) continue;
                    this.itrList.add(Integer.valueOf(StringUtils.isNotBlank((String)m.group(1)) ? m.group(1) : "1"));
                }
                if (0 < this.itrList.size()) {
                    Collections.sort(this.itrList);
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.itrCount < 1000;
        }

        @Override
        public String next() {
            ++this.itrCount;
            do {
                ++this.next;
            } while (this.itrList.contains(this.next));
            return 1 < this.next ? this.rawShortName + String.valueOf(this.next) : this.rawShortName;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private String generateShortName(DocumentModel document) {
            String s = document.getTitle();
            if (s == null) {
                s = "";
            }
            return IdUtils.generateId((String)s, (String)"-", (boolean)true, (int)ShortNameGenerator.this.maxShortNameSize);
        }

        private List<DocumentModel> getSimilarShortNamesList(CoreSession session, String shortName) throws ToutaticeException {
            HashMap<String, Serializable> props = new HashMap<String, Serializable>();
            props.put("coreSession", (Serializable)session);
            props.put("useUnrestrictedSession", Boolean.TRUE);
            props.put("detachDocuments", Boolean.TRUE);
            PageProvider pp = this.getPageProviderService().getPageProvider(PAGE_PROVIDER_NAME, null, null, null, props, new Object[]{shortName});
            if (pp == null) {
                throw new ToutaticeException("Page provider not found: GET_SIMILAR_SHORTNAME");
            }
            return pp.getCurrentPage();
        }

        private PageProviderService getPageProviderService() throws ToutaticeException {
            if (null == this.ppService) {
                this.ppService = (PageProviderService)Framework.getLocalService(PageProviderService.class);
                if (null == this.ppService) {
                    throw new ToutaticeException("Failed to obtain the page provider service");
                }
            }
            return this.ppService;
        }
    }
}

