/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.lang;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.string.StringHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CGStringHelper {
    private static final CGStringHelper s_aInstance = new CGStringHelper();

    private CGStringHelper() {
    }

    @Nonnull
    public static String getClassLocalName(@Nonnull Object object) {
        ValueEnforcer.notNull(object, "Object");
        return CGStringHelper.getClassLocalName(object.getClass());
    }

    @Nonnull
    public static String getClassLocalName(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        return CGStringHelper.getClassLocalName(clazz.getName());
    }

    @Nonnull
    public static String getClassLocalName(@Nonnull String string) {
        ValueEnforcer.notNull(string, "ClassName");
        int n = string.lastIndexOf(46);
        return n == -1 ? string : string.substring(n + 1);
    }

    @Nonnull
    public static String getClassPackageName(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        return CGStringHelper.getClassPackageName(clazz.getName());
    }

    @Nonnull
    public static String getClassPackageName(@Nonnull String string) {
        ValueEnforcer.notNull(string, "ClassName");
        int n = string.lastIndexOf(46);
        return n == -1 ? "" : string.substring(0, n);
    }

    @Nonnull
    public static String getSafeClassName(@Nullable Object object) {
        if (object instanceof Class) {
            return ((Class)object).getName();
        }
        if (object != null) {
            return object.getClass().getName();
        }
        return "null";
    }

    @Nonnull
    public static String getDirectoryFromPackage(@Nonnull Package package_) {
        ValueEnforcer.notNull(package_, "Package");
        return CGStringHelper.getPathFromClass(package_.getName());
    }

    @Nonnull
    public static String getDirectoryFromPackage(@Nonnull String string) {
        return CGStringHelper.getPathFromClass(string);
    }

    @Nonnull
    public static String getPathFromClass(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        return CGStringHelper.getPathFromClass(clazz.getName());
    }

    @Nonnull
    public static String getPathFromClass(@Nonnull String string) {
        ValueEnforcer.notNull(string, "ClassName");
        return string.replace('.', '/');
    }

    @Nonnull
    public static String getClassFromPath(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Path");
        return string.replace('\\', '.').replace('/', '.');
    }

    @Nonnull
    @Nonempty
    public static String getObjectAddress(@Nullable Object object) {
        if (object == null) {
            return "0x00000000";
        }
        return "0x" + StringHelper.getHexStringLeadingZero(System.identityHashCode(object), 8);
    }
}

