/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.elasticsearch.core.reindexing.docs.automation;

import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.runtime.api.Framework;
import org.opentoutatice.elasticsearch.api.OttcElasticSearchIndexing;

@Operation(id="Documents.ReIndexZeroDownTimeES", category="Services", label="Re-index all document of given repository in Elasticsearch with zero down time.")
public class ReIndexZeroDownTimeES {
    public static final String ID = "Documents.ReIndexZeroDownTimeES";
    @Param(name="repository", required=false)
    private String repository = "default";

    @OperationMethod
    public StringBlob run() throws Exception {
        String launchedStatus = null;
        OttcElasticSearchIndexing elasticSearchIndexing = (OttcElasticSearchIndexing)Framework.getService(ElasticSearchIndexing.class);
        if (elasticSearchIndexing.reIndexAllDocumentsWithZeroDownTime(this.getRepository())) {
            launchedStatus = String.format("Re-indexing launched for [%s] repository: check %s/zero-down-time-elasticsearch-reindexing.log", this.getRepository(), Framework.getProperty((String)"nuxeo.log.dir"));
        }
        return new StringBlob(launchedStatus);
    }

    public String getRepository() {
        return this.repository;
    }
}

