/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.restapi.server.jaxrs;

import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.server.jaxrs.RestOperationException;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.model.NoSuchDocumentException;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.ExceptionHelper;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;

@Path(value="/api/toutatice/v1{repo : (/repo/[^/]+?)?}")
@Produces(value={"text/html;charset=UTF-8"})
@WebObject(type="ToutaticeAPIRoot")
public class ToutaticeAPIRoot
extends ModuleRoot {
    @Path(value="/")
    public Object doGetRepository(@PathParam(value="repo") String repositoryParam) throws NoSuchDocumentException {
        if (StringUtils.isNotBlank((String)repositoryParam)) {
            String repoName = repositoryParam.substring("repo/".length() + 1);
            try {
                this.ctx.setRepositoryName(repoName);
            }
            catch (ClientException e) {
                throw new WebResourceNotFoundException(e.getMessage());
            }
        }
        return this.newObject("toutatice", new Object[0]);
    }

    @Path(value="/automation")
    public Object getAutomationEndPoint() throws Exception {
        return this.newObject("automation", new Object[0]);
    }

    public Object handleError(WebApplicationException cause) {
        Throwable unWrapException = ExceptionHelper.unwrapException((Throwable)cause);
        if (unWrapException instanceof RestOperationException) {
            int customHttpStatus = ((RestOperationException)unWrapException).getStatus();
            return WebException.newException((String)cause.getMessage(), (Throwable)cause, (int)customHttpStatus);
        }
        return WebException.newException((String)cause.getMessage(), (Throwable)unWrapException);
    }
}

