/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.addons.toutapad.ecm.web;

import fr.toutatice.addons.toutapad.ecm.helpers.ToutapadDocumentHelper;
import fr.toutatice.addons.toutapad.ecm.services.EtherpadClientService;
import fr.toutatice.addons.toutapad.ecm.web.ToutapadActions;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.runtime.api.Framework;

@Name(value="toutapadActions")
@Scope(value=ScopeType.CONVERSATION)
public class ToutapadActionsBean
implements ToutapadActions,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ToutapadActionsBean.class);
    @In(create=true)
    protected transient NavigationContext navigationContext;
    protected transient EtherpadClientService padService;

    @Override
    public String getPADURL() {
        String URL = "";
        try {
            DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
            URL = this.getPADClientService().getPADURL(currentDoc, true);
        }
        catch (Exception e) {
            log.error((Object)("Failed to get the current document pad URL, error: " + e.getMessage()));
        }
        return URL;
    }

    public String getPADReadOnlyURL() {
        String URL = "";
        try {
            DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
            URL = this.getPADClientService().getPADReadOnlyURL(currentDoc);
        }
        catch (Exception e) {
            log.error((Object)("Failed to get the current document pad read only URL, error: " + e.getMessage()));
        }
        return URL;
    }

    @Override
    public String getPADPublicURL() {
        String URL = "";
        try {
            DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
            URL = this.getPADClientService().getPADPublicURL(currentDoc);
        }
        catch (Exception e) {
            log.error((Object)("Failed to get the current document pad public URL, error: " + e.getMessage()));
        }
        return URL;
    }

    @Override
    public boolean isPADViewConnectedMode() {
        boolean connected = false;
        try {
            connected = this.getPADClientService().isPADViewConnectedMode();
        }
        catch (Exception e) {
            log.error((Object)("Failed to get the status of the view mode, error: " + e.getMessage()));
        }
        return connected;
    }

    @Override
    public String getPADContent(String mimetype) {
        String content = "";
        try {
            DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
            content = this.getPADClientService().getPADContent(currentDoc, mimetype);
            ToutapadDocumentHelper.synchronizePad(currentDoc.getCoreSession(), currentDoc, content);
        }
        catch (Exception e) {
            log.error((Object)("Failed to get the current document pad content, error: " + e.getMessage()));
        }
        return content;
    }

    @Override
    public boolean isPADAvailable() {
        boolean status = false;
        try {
            DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
            if ("ToutaticePad".equals(currentDoc.getType())) {
                this.getPADClientService().getPADContent(currentDoc, "text");
                status = true;
            }
        }
        catch (Exception e) {
            log.error((Object)("Error status of the Etherpad server, error: " + e.getMessage()));
        }
        return status;
    }

    private EtherpadClientService getPADClientService() throws ClientException {
        try {
            if (null == this.padService) {
                this.padService = (EtherpadClientService)Framework.getService(EtherpadClientService.class);
            }
        }
        catch (Exception e) {
            throw new ClientException("Failed to obtain the Etherpad client service, error: " + e.getMessage());
        }
        return this.padService;
    }
}

