/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.services.mee.ecm.listeners;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class MerensVerifyDataListener
implements EventListener {
    private static final Log log = LogFactory.getLog(MerensVerifyDataListener.class);
    private static final String DEFAULT_GPS_LONGITUDE = "";
    private static final String DEFAULT_GPS_LATITUDE = "";
    public static final String TRIM_PATTERN = "\\s";
    public static final String GPS_POSITION_PATTERN = "^[-\\+]?\\d+(\\.?\\d+)?$";

    public void handleEvent(Event event) throws ClientException {
        DocumentEventContext eventContext;
        DocumentModel document;
        if (event.getContext() instanceof DocumentEventContext && null != (document = (eventContext = (DocumentEventContext)event.getContext()).getSourceDocument()) && "MerEnsRessource".equals(document.getType()) && !document.isImmutable()) {
            String latitude = (String)((Object)document.getPropertyValue("merensressource:latitude"));
            String longitude = (String)((Object)document.getPropertyValue("merensressource:longitude"));
            latitude = latitude.replaceAll(TRIM_PATTERN, "");
            longitude = longitude.replaceAll(TRIM_PATTERN, "");
            if (!latitude.matches(GPS_POSITION_PATTERN) || !longitude.matches(GPS_POSITION_PATTERN)) {
                log.warn((Object)("Either the latitude or the longitude coordinate might not fit the GPS format (latitude='" + latitude + "', longitude='" + longitude + "')"));
                latitude = "";
                longitude = "";
            }
            document.setPropertyValue("merensressource:latitude", (Serializable)((Object)latitude));
            document.setPropertyValue("merensressource:longitude", (Serializable)((Object)longitude));
        }
    }
}

