/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support.numeric;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.index.fielddata.LongValues;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.support.ScriptValues;

public class ScriptLongValues
extends LongValues
implements ScriptValues {
    final SearchScript script;
    private Object value;
    private long[] values = new long[1];
    private int valueCount;
    private int valueOffset;

    public ScriptLongValues(SearchScript script) {
        super(true);
        this.script = script;
    }

    @Override
    public SearchScript script() {
        return this.script;
    }

    @Override
    public int setDocument(int docId) {
        this.docId = docId;
        this.script.setNextDocId(docId);
        this.value = this.script.run();
        if (this.value == null) {
            this.valueCount = 0;
        } else if (this.value instanceof Number) {
            this.valueCount = 1;
            this.values[0] = ((Number)this.value).longValue();
        } else if (this.value.getClass().isArray()) {
            this.valueCount = Array.getLength(this.value);
            this.values = ArrayUtil.grow((long[])this.values, (int)this.valueCount);
            for (int i = 0; i < this.valueCount; ++i) {
                this.values[i] = ((Number)Array.get(this.value, i)).longValue();
            }
        } else if (this.value instanceof Collection) {
            this.valueCount = ((Collection)this.value).size();
            this.values = ArrayUtil.grow((long[])this.values, (int)this.valueCount);
            int i = 0;
            Iterator it = ((Collection)this.value).iterator();
            while (it.hasNext()) {
                this.values[i] = ((Number)it.next()).longValue();
                ++i;
            }
            assert (i == this.valueCount);
        } else {
            throw new AggregationExecutionException("Unsupported script value [" + this.value + "]");
        }
        this.valueOffset = 0;
        return this.valueCount;
    }

    @Override
    public long nextValue() {
        assert (this.valueOffset < this.valueCount);
        return this.values[this.valueOffset++];
    }
}

