/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.web.document;

import fr.toutatice.ecm.platform.core.constants.ToutaticeGlobalConst;
import fr.toutatice.ecm.platform.web.context.ToutaticeNavigationContext;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.contentview.jsf.ContentView;
import org.nuxeo.ecm.platform.contentview.seam.ContentViewActions;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;

@Name(value="acarenSearchObserver")
@Scope(value=ScopeType.EVENT)
@Install(precedence=56)
public class AcrennesSearchObserverBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AcrennesSearchObserverBean.class);
    @In(required=false, create=true)
    private ContentViewActions contentViewActions;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(required=false, create=true)
    protected NavigationContext navigationContext;

    @Observer(value={"documentSelectionChanged"})
    public void setSearchDocumentModelPath() throws ClientException {
        if (null == this.navigationContext || null == this.contentViewActions) {
            return;
        }
        try {
            DocumentModel searchDoc;
            ContentView cv;
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            Path searchPath = currentDocument.getPath();
            if (!currentDocument.isFolder()) {
                searchPath = searchPath.removeLastSegments(1);
            }
            if ((cv = this.contentViewActions.getContentView("cv_acaren_advanced_search")) != null) {
                searchDoc = cv.getSearchDocumentModel();
                if (searchDoc != null) {
                    searchDoc.setPropertyValue("advanced_search:searchpath", (Serializable)new String[]{searchPath.toString()});
                    cv.setSearchDocumentModel(searchDoc);
                } else {
                    log.error((Object)"No AdvancedSearchDocument for ContentView : cv_acaren_advanced_search");
                }
            } else {
                log.error((Object)"AdvancedSearch ContentView unavaible: cv_acaren_advanced_search");
            }
            cv = this.contentViewActions.getContentView("cv_acaren_faceted_search");
            if (cv != null) {
                searchDoc = cv.getSearchDocumentModel();
                if (searchDoc != null) {
                    searchDoc.setPropertyValue("faceted_search_default:ecm_path", (Serializable)new String[]{searchPath.toString()});
                    cv.setSearchDocumentModel(searchDoc);
                } else {
                    log.error((Object)"No FacetedSearchDocument for ContentView : cv_acaren_faceted_search");
                }
            } else {
                log.error((Object)"FacetedSearch ContentView unavaible: cv_acaren_faceted_search");
            }
            DocumentModel spaceDocument = ((ToutaticeNavigationContext)this.navigationContext).getSpaceDoc(currentDocument);
            if (null != spaceDocument && !ToutaticeGlobalConst.NULL_DOCUMENT_MODEL.getType().equals(spaceDocument.getType())) {
                searchPath = spaceDocument.getPath();
            }
            if ((cv = this.contentViewActions.getContentView("relation_search")) != null) {
                searchDoc = cv.getSearchDocumentModel();
                if (searchDoc != null) {
                    searchDoc.setPropertyValue("relation_search:ecm_path", (Serializable)new String[]{searchPath.toString()});
                    cv.setSearchDocumentModel(searchDoc);
                } else {
                    log.error((Object)"No RelationSearchDocument for ContentView : relation_search");
                }
            } else {
                log.error((Object)"RelationSearch ContentView unavaible: relation_search");
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to initialize the search path of both the advanced and faceted search forms, error: " + e.getLocalizedMessage()));
        }
    }
}

