/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.automation;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;

@Operation(id="Blob.NbPagePDF", category="Files", label="Get the page number of pdf.", description="Get the page number of a 'blob' is a pdf file. The number of page is accessible via the context variable 'nbpage' if there is not xpathnbpage specifie. ")
public class GetNbPagePDFFile {
    public static final String ID = "Blob.NbPagePDF";
    public static final String VAR_NBPAGE = "nbpage";
    @Context
    protected OperationContext ctx;
    @Param(name="xpathBlob", required=true, order=0)
    protected String xpathblob;
    @Param(name="xpathNbPage", required=false, order=1)
    protected String xpathnbpage;

    @OperationMethod
    public DocumentModel run(DocumentModel doc) throws Exception {
        int nbPages = 0;
        BlobProperty blobPpty = (BlobProperty)doc.getProperty(this.xpathblob);
        InputStream is = null;
        PDDocument docPdfBox = null;
        String mimeType = ((StreamingBlob)blobPpty.getValue()).getMimeType();
        if (mimeType.equals("application/pdf")) {
            try {
                is = ((StreamingBlob)blobPpty.getValue()).getStream();
                PDFParser parser = new PDFParser(is);
                parser.parse();
                docPdfBox = parser.getPDDocument();
                nbPages = docPdfBox.getNumberOfPages();
            }
            catch (PropertyException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (docPdfBox != null) {
                    docPdfBox.close();
                }
            }
        }
        if (this.xpathnbpage != null) {
            doc.setPropertyValue(this.xpathnbpage, (Serializable)Integer.valueOf(nbPages));
        } else {
            this.ctx.put(VAR_NBPAGE, (Object)nbPages);
        }
        return doc;
    }
}

