/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.automation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.event.EventServiceAdmin;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Service.IndexRepository", category="Services", label="Re-index the repository", since="5.3.2", description="Will save all the documents of the repository recursively")
public class IndexRepository {
    public static final String ID = "Service.IndexRepository";
    private static final Log log = LogFactory.getLog(IndexRepository.class);
    private int nbDocsProcessed;
    @Context
    protected CoreSession session;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OperationMethod
    public boolean run() throws Exception {
        boolean status = true;
        log.info((Object)"D\u00e9marrage du processus de r\u00e9-indexation...");
        EventServiceAdmin adm = (EventServiceAdmin)Framework.getLocalService(EventServiceAdmin.class);
        adm.setListenerEnabledFlag("dclistener", false);
        try {
            DocumentModelList domains = this.session.query("SELECT * FROM Domain WHERE ecm:mixinType != 'HiddenInNavigation' AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted'");
            int nbrDomains = domains.size();
            int nbrDomainProcessed = 1;
            for (DocumentModel domain : domains) {
                log.info((Object)("D\u00e9marrage du traitement du domaine '" + domain.getTitle() + "'..."));
                this.nbDocsProcessed = 0;
                long startTime = System.currentTimeMillis();
                this.saveChidlren(domain);
                long endTime = System.currentTimeMillis();
                log.info((Object)("[" + nbrDomainProcessed++ + "/" + nbrDomains + "] Fin de traitement du domaine '" + domain.getTitle() + "', nombre de documents: " + this.nbDocsProcessed + ", temps: " + (endTime - startTime) + " ms"));
            }
        }
        catch (Exception e) {
            status = false;
            log.error((Object)("Failed to execute re-indexing the repository, error: " + e.getMessage()));
        }
        finally {
            adm.setListenerEnabledFlag("dclistener", true);
        }
        log.info((Object)"Fin du processus de r\u00e9-indexation");
        return status;
    }

    private void saveChidlren(DocumentModel parent) {
        try {
            DocumentModelList children = this.session.query("SELECT * FROM Document WHERE ecm:parentId = '" + parent.getId() + "' AND ecm:mixinType != 'HiddenInNavigation' AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted'");
            for (DocumentModel child : children) {
                if (child.isFolder()) {
                    this.saveChidlren(child);
                }
                this.session.saveDocument(child);
                ++this.nbDocsProcessed;
                log.info((Object)("Document trait\u00e9 '" + child.getTitle() + "', chemin: '" + child.getPathAsString() + "'"));
            }
        }
        catch (ClientException e) {
            log.error((Object)("Failed to save the children of the parent document '" + parent.getName() + "'"));
        }
    }
}

