/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.java2d;

import it.tidalwave.image.ImageUtils;
import it.tidalwave.image.java2d.Java2DUtils;
import it.tidalwave.image.op.AssignColorProfileOp;
import it.tidalwave.image.op.OperationImplementation;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.RenderedImage;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignColorProfileJ2DOp
extends OperationImplementation<AssignColorProfileOp, BufferedImage> {
    private static final String CLASS = AssignColorProfileJ2DOp.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    protected BufferedImage execute(AssignColorProfileOp operation, BufferedImage bufferedImage) {
        ICC_Profile colorProfile = operation.getICCProfile();
        logger.fine("assignColorProfile(" + ImageUtils.getICCProfileName((ICC_Profile)colorProfile) + ")");
        Java2DUtils.logImage((Logger)logger, (String)">>>> source bufferedImage", (RenderedImage)bufferedImage);
        ICC_ColorSpace colorSpace = new ICC_ColorSpace(colorProfile);
        ComponentColorModel colorModel = new ComponentColorModel(colorSpace, false, false, 1, bufferedImage.getRaster().getDataBuffer().getDataType());
        bufferedImage = new BufferedImage(colorModel, bufferedImage.getRaster(), false, Java2DUtils.getProperties((BufferedImage)bufferedImage));
        Java2DUtils.logImage((Logger)logger, (String)">>>> assignColorProfile() returning ", (RenderedImage)bufferedImage);
        return bufferedImage;
    }
}

