/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.procedures.record.security.policy;

import java.security.Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.util.StringUtils;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.security.AbstractSecurityPolicy;
import org.osivia.procedures.record.security.policy.SecurityPolicyDelegator;

public class RecordSecurityPolicy
extends AbstractSecurityPolicy {
    private static final Log log = LogFactory.getLog(RecordSecurityPolicy.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Access checkPermission(Document doc, ACP mergedAcp, Principal principal, String permission, String[] resolvedPermissions, String[] additionalPrincipals) {
        Access access = Access.UNKNOWN;
        if (doc != null && doc.getType() != null && StringUtils.equals((String)"Record", (String)doc.getType().getName()) && StringUtils.equals((String)"Read", (String)permission)) {
            try (Object session = null;){
                String repositoryName = "default";
                if (doc.getSession() != null) {
                    repositoryName = doc.getSession().getRepositoryName();
                }
                try {
                    access = SecurityPolicyDelegator.check(repositoryName, principal, doc, access);
                }
                catch (DocumentException e) {
                    access = Access.UNKNOWN;
                }
            }
        }
        return access;
    }

    public boolean isRestrictingPermission(String permission) {
        assert (permission.equals("Browse"));
        return false;
    }

    public boolean isExpressibleInQuery() {
        return true;
    }

    public SQLQuery.Transformer getQueryTransformer() {
        return SQLQuery.Transformer.IDENTITY;
    }
}

