/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.listener;

import fr.toutatice.ecm.platform.constants.PPFConstants;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeOperationHelper;
import fr.toutatice.ecm.platform.core.utils.exception.ToutaticeException;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class PPFEventListener
implements EventListener,
PPFConstants {
    private static final Log log = LogFactory.getLog(PPFEventListener.class);
    private static final String PARENT_PATH = "parentPath";

    public void handleEvent(Event event) throws ClientException {
        if (event.getContext() instanceof DocumentEventContext) {
            Boolean isPublishSpace;
            DocumentEventContext eventContext = (DocumentEventContext)event.getContext();
            DocumentModel doc = eventContext.getSourceDocument();
            if (null != doc && (doc.isImmutable() || doc.hasFacet("HiddenInNavigation") || doc.hasFacet("SystemDocument"))) {
                return;
            }
            if ("emptyDocumentModelCreated".equals(event.getName())) {
                String[] ppteValue;
                String parentPath = (String)((Object)eventContext.getProperty(PARENT_PATH));
                if (null == parentPath) {
                    return;
                }
                CoreSession session = eventContext.getCoreSession();
                DocumentModel parent = session.getDocument((DocumentRef)new PathRef(parentPath));
                Boolean isPublishSpace2 = this.isBelongPublishSpace(parent, eventContext.getCoreSession());
                if (isPublishSpace2.booleanValue() && (ppteValue = (String[])parent.getPropertyValue("ttc:lstTargetedPublic")) != null && ppteValue.length > 0) {
                    doc.setPropertyValue("ttc:lstTargetedPublic", (Serializable)ppteValue);
                }
            }
            if ("beforeDocumentModification".equals(event.getName()) && (isPublishSpace = this.isBelongPublishSpace(doc, eventContext.getCoreSession())).booleanValue()) {
                this.updateAcls(doc, eventContext.getCoreSession(), false);
            }
            if ("documentCreated".equals(event.getName()) && (isPublishSpace = this.isBelongPublishSpace(doc, eventContext.getCoreSession())).booleanValue()) {
                this.updateAcls(doc, eventContext.getCoreSession(), true);
            }
        }
    }

    private Boolean isBelongPublishSpace(DocumentModel doc, CoreSession cSession) {
        boolean b = false;
        DocumentModelList spaceDocsList = ToutaticeDocumentHelper.getParentPublishSpaceList((CoreSession)cSession, (DocumentModel)doc, (boolean)true, (boolean)false);
        b = spaceDocsList != null && !spaceDocsList.isEmpty();
        return b;
    }

    private void updateAcls(DocumentModel doc, CoreSession cSession, boolean immediate) throws PropertyException, ClientException {
        Property pptPublicCible = null;
        try {
            pptPublicCible = doc.getProperty("ttc:lstTargetedPublic");
        }
        catch (Exception e1) {
            log.warn((Object)("Property not found in '" + doc.getName() + "', error : " + e1.getMessage()));
            immediate = false;
        }
        boolean isPcDirty = false;
        if (pptPublicCible != null) {
            isPcDirty = pptPublicCible.isDirty();
        }
        if (isPcDirty || immediate) {
            try {
                ToutaticeOperationHelper.runOperationChain((CoreSession)cSession, (String)"updateAcls", (Object)doc);
            }
            catch (ToutaticeException e) {
                log.error((Object)("Failed to update ACLs: '" + doc.getName() + "', error: " + e.getMessage()));
            }
        }
    }
}

