/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.ecm.attached.files.url.converter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.core.Manager;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.util.SeamComponentCallHelper;
import org.opentoutatice.ecm.attached.images.bean.OttcDocumentActionsBean;

@FacesConverter(value="org.opentoutatice.ecm.attached.files.url.converter.DocumentContentConverter")
public class DocumentContentConverter
implements Converter {
    private static final String ATTACHED_RESOURCE_INDICATOR = "attachedImages";
    static final Pattern PATTERN_COMPONENT_LINK_OR_RESOURCE = Pattern.compile("(src|href)(=\")([.[^\"]]+\")");
    static final Pattern PATTERN_COMPONENT_ATTACHED_RESOURCE = Pattern.compile("(nxfile/default/)([a-zA-Z0-9[-]&&[^/]]*)(/ttc:images/[.[^\"]]*\")");
    static final Pattern PATTERN_COMPONENT_ATTACHED_RESOURCE_PARAM = Pattern.compile("([?]conversationId=[.[^\"]]+)");
    static final Pattern PATTERN_MODEL_ATTACHED_RESOURCE = Pattern.compile("(nxfile/default/)(".concat("attachedImages").concat(")").concat("(/ttc:images/[.[^\"]]*\")"));

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        StringBuffer replacement = new StringBuffer();
        if (value != null) {
            Matcher pictMatcher = PATTERN_COMPONENT_ATTACHED_RESOURCE.matcher(value);
            StringBuffer pictReplacementStack = new StringBuffer();
            while (pictMatcher.find()) {
                String g3 = pictMatcher.group(3);
                Matcher paramMatcher = PATTERN_COMPONENT_ATTACHED_RESOURCE_PARAM.matcher(g3);
                if (paramMatcher.find()) {
                    g3 = StringUtils.remove((String)g3, (String)paramMatcher.group(1));
                }
                pictMatcher.appendReplacement(pictReplacementStack, "$1attachedImages" + g3);
            }
            replacement = pictMatcher.appendTail(pictReplacementStack);
            value = replacement.toString();
            return value;
        }
        return replacement.toString();
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        StringBuffer replacement = new StringBuffer();
        if (value != null) {
            Matcher matcher = PATTERN_MODEL_ATTACHED_RESOURCE.matcher((String)value);
            OttcDocumentActionsBean actionsBean = (OttcDocumentActionsBean)((Object)SeamComponentCallHelper.getSeamComponentByName((String)"documentActions"));
            DocumentModel currentDoc = actionsBean.getCurrentDocument();
            if (currentDoc != null) {
                StringBuffer pictReplacementStack = new StringBuffer();
                while (matcher.find()) {
                    String docId = "creatingDoc";
                    if (currentDoc.getId() != null) {
                        docId = currentDoc.getId();
                    }
                    String g3 = matcher.group(3);
                    if (currentDoc.getId() == null) {
                        Manager conversationManager = (Manager)SeamComponentCallHelper.getSeamComponentByName((String)"org.jboss.seam.core.manager");
                        String conversationId = "?".concat(conversationManager.getConversationIdParameter()).concat("=").concat(conversationManager.getCurrentConversationId());
                        g3 = StringUtils.remove((String)g3, (String)"\"").concat(conversationId).concat("\"");
                    }
                    matcher.appendReplacement(pictReplacementStack, "$1" + docId + g3);
                }
                replacement = matcher.appendTail(pictReplacementStack);
                value = replacement.toString();
                return (String)value;
            }
        }
        return replacement.toString();
    }
}

