/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.services.p1d.ecm.automation;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.BlobCollector;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;

@Operation(id="P1D.AddAttachmentWithDate", category="Files", label="Ajout de fichier avec date", description="Ajoute un fichier \u00e0 la liste d\u00e9sign\u00e9e par le chemin XPath. Le fichier peut \u00eatre accompagn\u00e9 d'une date")
public class AddDocumentFileWithDate {
    public static final String ID = "P1D.AddAttachmentWithDate";
    private static final String PROP_FICHIER = "fichier";
    private static final String PROP_DATE = "date";
    @Context
    protected CoreSession session;
    @Param(name="xpath")
    protected String xpath;
    @Param(name="document")
    protected DocumentModel doc;
    @Param(name="date", required=false)
    protected Date date = new Date();
    @Param(name="save", required=false, values={"true"})
    protected boolean save = true;

    @OperationMethod(collector=BlobCollector.class)
    public Blob run(Blob blob) {
        Property prop = this.doc.getProperty(this.xpath);
        if (prop.isList()) {
            this.appendFileWithMetadata((ListProperty)prop, blob);
            if (this.save) {
                this.doc = this.session.saveDocument(this.doc);
            }
        } else {
            throw new IllegalArgumentException("La propri\u00e9t\u00e9 '" + this.xpath + "' du document devrait d\u00e9signer une liste. Mais \u00e7a n'est pas le cas.");
        }
        return blob;
    }

    private void appendFileWithMetadata(ListProperty list, Blob blob) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put(PROP_FICHIER, (Serializable)blob);
        map.put(PROP_DATE, this.date);
        list.addValue(map);
    }
}

