/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.services.p1d.ecm.automation;

import java.util.List;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskService;

@Operation(id="Service.GetCurrentStepWorkflow", category="Services", label="Retourne l'\u00e9tape courant du document", description="Retourne l'\u00e9tape courant du document")
public class GetCurrentStepWorkflow {
    public static final String ID = "Service.GetCurrentStepWorkflow";
    private static final String MIME_JSON = "application/json";
    @Context
    protected CoreSession coreSession;
    @Context
    protected TaskService taskService;

    @OperationMethod
    public Object run(DocumentModel input) {
        String currentStep = this.getCurrentStep(input);
        JSONObject jso = new JSONObject();
        if (StringUtils.isNotBlank((String)currentStep)) {
            jso.element("step", (Object)currentStep);
        }
        return new StringBlob(jso.toString(), MIME_JSON);
    }

    private String getCurrentStep(DocumentModel input) {
        List tasks = this.taskService.getCurrentTaskInstances(this.coreSession);
        for (Task task : tasks) {
            List ids = task.getTargetDocumentsIds();
            for (String id : ids) {
                if (!input.getId().equals(id)) continue;
                return task.getName();
            }
        }
        return null;
    }
}

