/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.helper;

import fr.toutatice.ecm.platform.core.utils.exception.ToutaticeException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.api.Framework;

public class ToutaticeDirectoryMngtHelper {
    private static final Log log = LogFactory.getLog(ToutaticeDirectoryMngtHelper.class);
    private static ToutaticeDirectoryMngtHelper instance;
    private DirectoryService service;

    private ToutaticeDirectoryMngtHelper() {
    }

    public static ToutaticeDirectoryMngtHelper instance() throws ToutaticeException {
        if (null == instance) {
            instance = new ToutaticeDirectoryMngtHelper();
        }
        return instance;
    }

    public String getDirectoryEntryLabel(String directory, String entryKey) {
        return this.getDirectoryEntryLabel(directory, entryKey, Locale.FRENCH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDirectoryEntryLabel(String directory, String entryKey, Locale locale) {
        String entryLabel = "";
        Session directorySession = null;
        if (StringUtils.isNotBlank((String)directory) && StringUtils.isNotBlank((String)entryKey)) {
            try {
                directorySession = this.getService().open(directory);
                if (null != directorySession) {
                    DocumentModel entry = directorySession.getEntry(entryKey);
                    String schemaName = this.getService().getDirectorySchema(directory.toString());
                    String labelProperty = "label";
                    try {
                        entryLabel = (String)entry.getProperty(schemaName, labelProperty);
                    }
                    catch (Exception el) {
                        labelProperty = new StringBuffer(3).append(labelProperty).append("_").append(locale.getLanguage()).toString();
                        entryLabel = (String)entry.getProperty(schemaName, labelProperty);
                    }
                } else {
                    log.error((Object)("Failed to obtain a session to the the directory '" + directory + "'"));
                }
            }
            catch (Exception e) {
                log.warn((Object)("Failed to either get a session to the directory '" + directory + "' or failed to get the entry '" + entryKey + "', error: " + e.getMessage()));
            }
            finally {
                if (null != directorySession) {
                    try {
                        directorySession.close();
                    }
                    catch (DirectoryException e) {
                        log.error((Object)("Failed to close the session to the directory '" + directory + "', error: " + e.getMessage()));
                    }
                }
            }
        }
        return entryLabel;
    }

    public DocumentModelList getEntries(String directory) throws ToutaticeException {
        DocumentModelList entries = null;
        Session directorySession = null;
        try {
            directorySession = this.getService().open(directory);
            if (null != directorySession) {
                entries = directorySession.getEntries();
            } else {
                log.error((Object)("Failed to obtain a session to the the directory '" + directory + "'"));
            }
        }
        catch (Exception e) {
            log.warn((Object)("Failed to either get a session to the directory '" + directory + "' or failed to get the entries, error: " + e.getMessage()));
            throw new ToutaticeException(e);
        }
        finally {
            if (null != directorySession) {
                try {
                    directorySession.close();
                }
                catch (DirectoryException e) {
                    log.error((Object)("Failed to close the session to the directory '" + directory + "', error: " + e.getMessage()));
                }
            }
        }
        return entries;
    }

    public String getDirectoryEntryLocalizedLabel(String directory, String entryKey, Locale locale) {
        String label = this.getDirectoryEntryLabel(directory, entryKey, locale);
        return ToutaticeDirectoryMngtHelper.translate(label, locale);
    }

    public String getDirectoryEntriesLocalizedLabel(String[] directories, String rawKeys, Locale locale) {
        String label = "";
        List<String> labelsList = this.getDirectoryEntriesLocalizedLabelList(directories, rawKeys, locale);
        for (String item : labelsList) {
            label = label + item + ",";
        }
        return label.replaceAll(",$", "");
    }

    public List<String> getDirectoryEntriesLocalizedLabelList(String[] directories, String rawKeys, Locale locale) {
        ArrayList<String> list = new ArrayList<String>();
        String[] keysList = rawKeys.split("/");
        if (keysList.length > directories.length) {
            log.warn((Object)("The list of directories ('" + directories + "') cannot be smaller than the keys list ('" + keysList + "')"));
            return list;
        }
        int index = 0;
        for (String key : keysList) {
            String keyLabel;
            if (!StringUtils.isNotBlank((String)(keyLabel = this.getDirectoryEntryLocalizedLabel(directories[index++], key, locale)))) continue;
            list.add(keyLabel);
        }
        return list;
    }

    public DocumentModelList getItems(String directoryName, String fieldName, String pattern) throws ToutaticeException {
        HashMap<String, Serializable> filter = new HashMap<String, Serializable>();
        filter.put(fieldName, (Serializable)((Object)pattern));
        HashSet<String> fulltext = new HashSet<String>();
        fulltext.add(fieldName);
        return this.getItems(directoryName, filter, fulltext, null);
    }

    public DocumentModelList getItems(String directoryName, Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy) throws ToutaticeException {
        DocumentModelList items = null;
        Session session = null;
        try {
            session = this.getService().open(directoryName);
        }
        catch (DirectoryException e) {
            throw new ToutaticeException("could not open session on directory '" + directoryName + "', error: " + e.getMessage());
        }
        if (null != session) {
            try {
                items = session.query(filter, fulltext, orderBy);
            }
            catch (Exception e) {
                throw new ToutaticeException("could not query on directory '" + directoryName + "', error: " + e.getMessage());
            }
            finally {
                try {
                    if (null != session) {
                        session.close();
                    }
                }
                catch (DirectoryException ce) {
                    log.error((Object)"Could not close directory session", (Throwable)ce);
                }
            }
        }
        throw new ToutaticeException("could not open session on directory: " + directoryName);
        return items;
    }

    private static String translate(String label, Locale locale) {
        String localizedLabel = label;
        if (null != locale) {
            localizedLabel = I18NUtils.getMessageString((String)"messages", (String)label, null, (Locale)locale);
        }
        return localizedLabel;
    }

    private DirectoryService getService() throws ToutaticeException {
        try {
            if (null == this.service) {
                this.service = (DirectoryService)Framework.getService(DirectoryService.class);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to get the directory service, exception message: " + e.getMessage()));
            throw new ToutaticeException(e);
        }
        return this.service;
    }
}

