/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.security;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;

public class MasterOwnerSecurityHelper {
    private MasterOwnerSecurityHelper() {
    }

    public static List<String> getMasterOwners(CoreSession session, DocumentModel document) {
        ArrayList<String> masterOwners = new ArrayList<String>(0);
        DocumentModel workspace = ToutaticeDocumentHelper.getWorkspace(session, document, true);
        if (workspace != null) {
            ACL[] acLs;
            ACP acp = workspace.getACP();
            for (ACL acl : acLs = acp.getACLs()) {
                for (ACE ace : acl) {
                    if (!"MasterOwner".equals(ace.getPermission())) continue;
                    masterOwners.add(ace.getUsername());
                }
            }
        }
        return masterOwners;
    }
}

