/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.management.metrics;

import org.javasimon.CallbackSkeleton;
import org.javasimon.Counter;
import org.javasimon.Simon;
import org.javasimon.Stopwatch;
import org.nuxeo.runtime.management.counters.CounterMXBeanImpl;
import org.nuxeo.runtime.management.metrics.MetricRegister;
import org.nuxeo.runtime.management.stopwatchs.StopwatchMXBeanImpl;

public class MetricRegisteringCallback
extends CallbackSkeleton {
    MetricRegister register;

    public MetricRegisteringCallback(MetricRegister register) {
        this.register = register;
    }

    public void simonCreated(Simon simon) {
        if (simon.getName() == null) {
            return;
        }
        this.register(simon);
    }

    public void simonDestroyed(Simon simon) {
        this.register.unregisterMXBean(simon.getName());
    }

    public void clear() {
        this.register.unregisterAll();
    }

    protected final void register(Simon simon) {
        Object mbean;
        if (simon instanceof Counter) {
            mbean = new CounterMXBeanImpl((Counter)simon);
        } else if (simon instanceof Stopwatch) {
            mbean = new StopwatchMXBeanImpl((Stopwatch)simon);
        } else {
            return;
        }
        this.register.registerMXBean(mbean, simon.getName(), mbean.getClass(), mbean.getType());
    }
}

