/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.builder;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.core.query.helper.NxqlHelper;
import fr.toutatice.ecm.platform.core.query.helper.ToutaticeEsQueryHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;

public class UserRootSectionsFinder
extends UnrestrictedSessionRunner {
    private static final Log log = LogFactory.getLog(UserRootSectionsFinder.class);
    protected static final String CONFIGURED_ROOT_SECTIONS_QUERY = "select * from Document where ecm:uuid %s and ecm:isVersion = 0 and ecm:currentLifeCycleState <> 'deleted' and ecm:mixinType = 'Folderish' and ecm:mixinType <> 'HiddenInNavigation'";
    protected static final String CHILDREN_QUERY = "select * from Document where ecm:uuid %s and ecm:isVersion = 0 and ecm:currentLifeCycleState <> 'deleted' and ecm:mixinType = 'Folderish' and ecm:mixinType <> 'HiddenInNavigation'";
    private DocumentModel currentDoc;
    private static Map<DocumentModel, DocumentModel> masterRootsCache = new ConcurrentHashMap<DocumentModel, DocumentModel>();
    private static Map<String, DocumentModelList> sectionsByDocCache = new ConcurrentHashMap<String, DocumentModelList>();
    private List<String> sectionsIds;
    private Set<String> spaceIds = new HashSet<String>();
    private static final Filter filter = new Filter(){
        private static final long serialVersionUID = 1284642449788813163L;

        public boolean accept(DocumentModel docModel) {
            return docModel.hasFacet("MasterPublishSpace");
        }
    };

    protected UserRootSectionsFinder(CoreSession session) {
        super(session);
    }

    public DocumentModelList getConfiguredUserRootSections(CoreSession userSession, DocumentModel document) {
        long b = System.currentTimeMillis();
        DocumentModelList sections = sectionsByDocCache.get(document.getId());
        if (CollectionUtils.isEmpty((Collection)sections)) {
            List<String> rootSectionsIds = this.getUserRootSectionsIds(userSession, document);
            if (CollectionUtils.isNotEmpty(rootSectionsIds)) {
                if (log.isDebugEnabled()) {
                    long e = System.currentTimeMillis();
                    log.debug((Object)("#getConfiguredUserRootSections: after rootSectionsIds: " + String.valueOf(e - b) + " ms"));
                }
                String query = String.format("select * from Document where ecm:uuid %s and ecm:isVersion = 0 and ecm:currentLifeCycleState <> 'deleted' and ecm:mixinType = 'Folderish' and ecm:mixinType <> 'HiddenInNavigation'", NxqlHelper.buildInClause(rootSectionsIds));
                sections = ToutaticeEsQueryHelper.unrestrictedQuery((CoreSession)userSession, (String)query, (int)rootSectionsIds.size());
                sectionsByDocCache.put(document.getId(), sections);
                if (log.isDebugEnabled()) {
                    long e = System.currentTimeMillis();
                    log.debug((Object)("#getConfiguredUserRootSections: end: " + String.valueOf(e - b) + " ms"));
                }
            }
        } else if (log.isDebugEnabled()) {
            long e = System.currentTimeMillis();
            log.debug((Object)("#getConfiguredUserRootSections: end: get in CACHE: " + String.valueOf(e - b) + " ms"));
        }
        return sections;
    }

    public List<String> getUserRootSectionsIds(CoreSession userSession, DocumentModel document) {
        this.currentDoc = document;
        this.runUnrestricted();
        return this.sectionsIds;
    }

    public void run() throws ClientException {
        DocumentModel publishingFolder = this.getPublishingFolder(this.session, this.currentDoc);
        if (publishingFolder != null) {
            this.sectionsIds = Arrays.asList((String[])publishingFolder.getPropertyValue("publish:sections"));
        }
    }

    protected DocumentModel getPublishingFolder(CoreSession userSession, DocumentModel document) {
        long b = System.currentTimeMillis();
        DocumentModel publishingFolder = null;
        Filter hasSectionsFilter = new Filter(){
            private static final long serialVersionUID = 1L;

            public boolean accept(DocumentModel document) {
                return document.hasSchema("publishing") && ArrayUtils.isNotEmpty((Object[])((String[])document.getPropertyValue("publish:sections")));
            }
        };
        DocumentModelList publishingFolders = ToutaticeDocumentHelper.getParentList((CoreSession)userSession, (DocumentModel)document, (Filter)hasSectionsFilter, (boolean)true, (boolean)true, (boolean)true);
        if (publishingFolders.size() > 0) {
            publishingFolder = (DocumentModel)publishingFolders.get(0);
        }
        if (log.isDebugEnabled()) {
            long e = System.currentTimeMillis();
            log.debug((Object)("#getPublishingFolder: " + String.valueOf(e - b) + " ms"));
        }
        return publishingFolder;
    }

    public boolean storePublishingSpaceId(String spaceId) {
        return this.spaceIds.add(spaceId);
    }

    public DocumentModel getMatserRoot(CoreSession session, DocumentModel section, DocumentModel document) {
        long b = System.currentTimeMillis();
        DocumentModel masterRoot = masterRootsCache.get(section);
        if (masterRoot == null) {
            DocumentModelList masterPublishRoots = ToutaticeDocumentHelper.getParentList((CoreSession)session, (DocumentModel)section, (Filter)filter, (boolean)true, (boolean)true);
            masterRoot = masterPublishRoots.size() > 0 ? (DocumentModel)masterPublishRoots.get(0) : ToutaticeDocumentHelper.getDomain((CoreSession)session, (DocumentModel)section, (boolean)true);
            masterRootsCache.put(section, masterRoot);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("MasterRoot | get in CACHE: " + masterRoot.getTitle()));
        }
        if (log.isDebugEnabled()) {
            long e = System.currentTimeMillis();
            log.debug((Object)("#getMatserRoot: " + String.valueOf(e - b) + " ms"));
        }
        return masterRoot;
    }

    public static void invalidateAllSectionsCache() {
        sectionsByDocCache = new ConcurrentHashMap<String, DocumentModelList>();
    }

    public static void invalidateSectionsCache(DocumentModel ws) {
        DocumentModelList descendants = ToutaticeEsQueryHelper.getDescendants((CoreSession)ws.getCoreSession(), (DocumentModel)ws, (boolean)true, (boolean)false);
        for (DocumentModel descendant : descendants) {
            sectionsByDocCache.remove(descendant.getId());
        }
    }
}

