/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.listener;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.jboss.seam.core.Events;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class ToutaticeSetPublicationSections
implements EventListener {
    public void handleEvent(Event event) throws ClientException {
        if (event.getContext() instanceof DocumentEventContext) {
            CoreSession session;
            DocumentModelList parentsList;
            DocumentEventContext eventContext = (DocumentEventContext)event.getContext();
            DocumentModel document = eventContext.getSourceDocument();
            boolean isMutable = !document.isImmutable();
            boolean hasPublishingShema = document.hasSchema("publishing");
            boolean isSection = "Section".equals(document.getType());
            if (isMutable && (hasPublishingShema || isSection) && null != (parentsList = ToutaticeDocumentHelper.getParentList((CoreSession)(session = eventContext.getCoreSession()), (DocumentModel)document, (Filter)new filterPublicationSpace(), (boolean)false)) && 0 < parentsList.size()) {
                DocumentModel parent = (DocumentModel)parentsList.get(0);
                String[] parentSectionIds = (String[])parent.getPropertyValue("publish:sections");
                if (hasPublishingShema) {
                    if (null != parentSectionIds && 0 < parentSectionIds.length) {
                        document.setPropertyValue("publish:sections", (Serializable)parentSectionIds);
                        session.saveDocument(document);
                    }
                } else if (session.hasPermission(eventContext.getPrincipal(), parent.getRef(), "Write")) {
                    ArrayList<String> newParentSectionIds = new ArrayList<String>();
                    if (null != parentSectionIds && 0 < parentSectionIds.length) {
                        newParentSectionIds.addAll(Arrays.asList(parentSectionIds));
                    }
                    newParentSectionIds.add(document.getId());
                    parent.setPropertyValue("publish:sections", (Serializable)newParentSectionIds.toArray(new String[newParentSectionIds.size()]));
                    session.saveDocument(parent);
                    Events.instance().raiseEvent("sectionModified", new Object[]{""});
                }
            }
        }
    }

    private class filterPublicationSpace
    implements Filter {
        private static final long serialVersionUID = 1L;

        private filterPublicationSpace() {
        }

        public boolean accept(DocumentModel document) {
            return document.hasSchema("publishing");
        }
    }
}

