/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html.iconimages;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.faces.context.FacesContext;
import org.richfaces.resource.AbstractJava2DUserResource;
import org.richfaces.resource.PostConstructResource;
import org.richfaces.resource.ResourceParameter;
import org.richfaces.resource.StateHolderResource;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

public abstract class PanelIconBasic
extends AbstractJava2DUserResource
implements StateHolderResource {
    private static final Dimension DIMENSION = new Dimension(16, 16);
    private Color color;
    @ResourceParameter(defaultValue="false")
    private boolean disabled;

    protected PanelIconBasic() {
        super(DIMENSION);
    }

    public void paint(Graphics2D graphics2D) {
        if (this.color == null || graphics2D == null) {
            return;
        }
        this.paintImage(graphics2D, this.color);
    }

    protected abstract void paintImage(Graphics2D var1, Color var2);

    public boolean isTransient() {
        return false;
    }

    @PostConstructResource
    public void initialize() {
        FacesContext context = FacesContext.getCurrentInstance();
        Skin skin = SkinFactory.getInstance((FacesContext)context).getSkin(context);
        Skin defaultSkin = SkinFactory.getInstance((FacesContext)context).getDefaultSkin(context);
        Integer colorParameter = skin.getColorParameter(context, this.disabled ? "tabDisabledTextColor" : "headerTextColor");
        if (colorParameter == null) {
            colorParameter = defaultSkin.getColorParameter(context, this.disabled ? "tabDisabledTextColor" : "headerTextColor");
        }
        this.color = new Color(colorParameter);
    }

    public void setDisabled(boolean topIcon) {
        this.disabled = topIcon;
    }

    public void writeState(FacesContext context, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.color.getRGB());
    }

    public void readState(FacesContext context, DataInput dataInput) throws IOException {
        this.color = new Color(dataInput.readInt());
    }
}

