/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.core.listener;

import fr.toutatice.ecm.acrennes.core.filter.AcrennesPFParentFilter;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;
import java.io.Serializable;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class AcrennesSetMetaData
implements PostCommitEventListener {
    public void handleEvent(EventBundle events) throws ClientException {
        for (Event event : events) {
            DocumentEventContext eventContext = (DocumentEventContext)event.getContext();
            DocumentModel document = eventContext.getSourceDocument();
            if (document.isProxy() || ToutaticeDocumentHelper.isRuntimeDocument((DocumentModel)document)) {
                return;
            }
            if ("documentModified".equals(event.getName())) {
                this.setModifiedDocMetaData(eventContext, document);
                continue;
            }
            if (!"documentMoved".equals(event.getName()) && !"documentCreatedByCopy".equals(event.getName())) continue;
            this.setMovedDocMetaData(eventContext, document);
        }
    }

    private void setModifiedDocMetaData(DocumentEventContext eventContext, DocumentModel document) throws ClientException {
        InnerSetModifiedDocMetaData runner = new InnerSetModifiedDocMetaData(eventContext.getCoreSession(), document);
        runner.silentRun(true);
    }

    private void setMovedDocMetaData(DocumentEventContext eventContext, DocumentModel document) throws ClientException {
        InnerSetMovedDocMetaData runner = new InnerSetMovedDocMetaData(eventContext.getCoreSession(), document);
        runner.silentRun(true);
    }

    private boolean doBelongToDomainPF(CoreSession session, DocumentModel document) throws ClientException {
        boolean status = false;
        DocumentModel domain = ToutaticeDocumentHelper.getDomain((CoreSession)session, (DocumentModel)document, (boolean)true);
        if (null != domain) {
            String type = (String)((Object)domain.getPropertyValue("acaren:commutateur"));
            status = "pf".equals(type);
        }
        return status;
    }

    private void updateDocTree(CoreSession session, DocumentModel doc, DocumentModel root) throws ClientException {
        boolean doSave = false;
        if (!doc.isImmutable() && (doc.hasSchema("tic") || doc.hasSchema("pilotage"))) {
            Serializable pv;
            if (doc.hasSchema("tic")) {
                pv = root.getPropertyValue("tic:academie");
                doc.setPropertyValue("tic:academie", pv);
                pv = root.getPropertyValue("tic:categoriePf");
                doc.setPropertyValue("tic:categoriePf", pv);
                doSave = true;
            }
            if (doc.hasSchema("pilotage")) {
                pv = root.getPropertyValue("pilotage:anneeScolaire");
                doc.setPropertyValue("pilotage:anneeScolaire", pv);
                doSave = true;
            }
            if (doSave) {
                session.saveDocument(doc);
            }
        }
        if (doc.isFolder()) {
            StringBuilder query = new StringBuilder();
            query.append("select * from Document where ecm:mixinType != 'HiddenInNavigation' AND ecm:isCheckedInVersion = 0 AND ");
            query.append("ecm:currentLifeCycleState != 'deleted' AND ecm:isProxy = 0 AND ecm:parentId = '");
            query.append(doc.getId());
            query.append("'");
            DocumentModelList children = session.query(query.toString());
            if (children != null && !children.isEmpty()) {
                for (DocumentModel child : children) {
                    this.updateDocTree(session, child, root);
                }
            }
        }
    }

    private class InnerSetMovedDocMetaData
    extends ToutaticeSilentProcessRunnerHelper {
        DocumentModel doc;

        public InnerSetMovedDocMetaData(CoreSession session, DocumentModel doc) {
            super(session);
            this.doc = doc;
        }

        public void run() throws ClientException {
            if (AcrennesSetMetaData.this.doBelongToDomainPF(this.session, this.doc)) {
                DocumentModelList parentList = ToutaticeDocumentHelper.getParentList((CoreSession)this.session, (DocumentModel)this.doc, (Filter)new AcrennesPFParentFilter(), (boolean)true, (boolean)true);
                if (null != parentList && !parentList.isEmpty()) {
                    DocumentModel parent = (DocumentModel)parentList.get(0);
                    AcrennesSetMetaData.this.updateDocTree(this.session, this.doc, parent);
                } else {
                    DocumentModel emptyDoc = this.session.createDocumentModel("PortalPage");
                    AcrennesSetMetaData.this.updateDocTree(this.session, this.doc, emptyDoc);
                }
            }
        }
    }

    private class InnerSetModifiedDocMetaData
    extends ToutaticeSilentProcessRunnerHelper {
        DocumentModel doc;

        public InnerSetModifiedDocMetaData(CoreSession session, DocumentModel doc) {
            super(session);
            this.doc = doc;
        }

        public void run() throws ClientException {
            if (AcrennesSetMetaData.this.doBelongToDomainPF(this.session, this.doc) && this.doc.isFolder() && this.doc.hasSchema("tic") && this.doc.hasSchema("pilotage")) {
                AcrennesSetMetaData.this.updateDocTree(this.session, this.doc, this.doc);
            }
        }
    }
}

