/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.versioning;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.CoreService;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.runtime.api.Framework;

public class OrphanVersionCleanupListener
implements PostCommitEventListener {
    private static final Log log = LogFactory.getLog(OrphanVersionCleanupListener.class);
    public static final long DEFAULT_COMMIT_SIZE = 1000L;
    public static final String DEFAULT_COMMIT_SIZE_PROP = "org.nuxeo.orphanVersionsCleanup.commitSize";

    protected long getCommitSize() {
        String commitSize = Framework.getProperty((String)DEFAULT_COMMIT_SIZE_PROP);
        if (commitSize == null) {
            return 1000L;
        }
        try {
            return Long.parseLong(commitSize);
        }
        catch (NumberFormatException e) {
            log.error((Object)"Invalid property org.nuxeo.orphanVersionsCleanup.commitSize", (Throwable)e);
            return 1000L;
        }
    }

    public void handleEvent(EventBundle events) {
        CoreService coreService = (CoreService)((Object)Framework.getService(CoreService.class));
        if (coreService == null) {
            return;
        }
        log.debug((Object)"Starting orphan versions cleanup");
        long n = coreService.cleanupOrphanVersions(this.getCommitSize());
        log.debug((Object)("Number of orphan versions deleted: " + n));
    }
}

