/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.OperationInput;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.core.cms.CMSBinaryContent;

public class ResourceUtil {
    private ResourceUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream inputStream, OutputStream outputStream, int bufSize) throws IOException {
        InputStream in = inputStream;
        BufferedOutputStream out = new BufferedOutputStream(outputStream, bufSize);
        try {
            byte[] b = new byte[4096];
            int i = -1;
            while ((i = in.read(b)) != -1) {
                out.write(b, 0, i);
            }
            out.flush();
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public static String getString(InputStream in, String charSet) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ResourceUtil.copy(in, out, 4096);
        return new String(out.toByteArray(), charSet);
    }

    public static CMSBinaryContent getCMSBinaryContent(NuxeoController ctx, String path, String fileIndex) throws Exception {
        return (CMSBinaryContent)ctx.executeNuxeoCommand(new CMSBinaryContentCommand(path, fileIndex));
    }

    public static CMSBinaryContent getPictureContent(NuxeoController ctx, String path, String content) throws Exception {
        return (CMSBinaryContent)ctx.executeNuxeoCommand(new PictureContentCommand(path, content));
    }

    public static CMSBinaryContent getBlobHolderContent(NuxeoController ctx, String path, String fileIndex) throws Exception {
        return (CMSBinaryContent)ctx.executeNuxeoCommand(new BlobHolderCommand(path, fileIndex));
    }

    private static class BlobHolderCommand
    implements INuxeoCommand {
        String path;
        String blobIndex;

        public BlobHolderCommand(String path, String blobIndex) {
            this.path = path;
            this.blobIndex = blobIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object execute(Session session) throws Exception {
            Document doc = (Document)session.newRequest("Document.Fetch").setHeader("X-NXDocumentProperties", "*").set("value", (Object)this.path).execute();
            Blob blob = null;
            try {
                blob = (Blob)session.newRequest("Blob.Get").setInput((OperationInput)doc).set("xpath", (Object)"/file:content").execute();
            }
            catch (Exception e) {
                throw new NuxeoException(3);
            }
            InputStream in = blob.getStream();
            File tempFile = File.createTempFile("tempFile4", ".tmp");
            CountingOutputStream cout = new CountingOutputStream((OutputStream)new FileOutputStream(tempFile));
            try {
                byte[] b = new byte[4096];
                int i = -1;
                while ((i = in.read(b)) != -1) {
                    cout.write(b, 0, i);
                }
                cout.flush();
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((OutputStream)cout);
            }
            CMSBinaryContent content = new CMSBinaryContent();
            content.setName(blob.getFileName());
            content.setFile(tempFile);
            content.setMimeType(blob.getMimeType());
            content.setFileSize(Long.valueOf(cout.getByteCount()));
            return content;
        }

        @Override
        public String getId() {
            return "BlobHolderCommand" + this.path + "/" + this.blobIndex;
        }
    }

    private static class PictureContentCommand
    implements INuxeoCommand {
        String path;
        String content;

        public PictureContentCommand(String path, String content) {
            this.path = path;
            this.content = content;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object execute(Session session) throws Exception {
            Document doc = (Document)session.newRequest("Document.Fetch").setHeader("X-NXDocumentProperties", "*").set("value", (Object)this.path).execute();
            PropertyList views = doc.getProperties().getList("picture:views");
            if (views != null) {
                for (Object viewObject : views.list()) {
                    PropertyMap view;
                    String title;
                    if (!(viewObject instanceof PropertyMap) || !this.content.equals(title = (view = (PropertyMap)viewObject).getString("title"))) continue;
                    PropertyMap fileContent = view.getMap("content");
                    String pathFile = fileContent.getString("data");
                    FileBlob blob = (FileBlob)session.getFile(pathFile);
                    FileInputStream in = new FileInputStream(blob.getFile());
                    File tempFile = File.createTempFile("tempFile2", ".tmp");
                    CountingOutputStream cout = new CountingOutputStream((OutputStream)new FileOutputStream(tempFile));
                    try {
                        byte[] b = new byte[4096];
                        int i = -1;
                        while ((i = ((InputStream)in).read(b)) != -1) {
                            cout.write(b, 0, i);
                        }
                        cout.flush();
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)in);
                        IOUtils.closeQuietly((OutputStream)cout);
                    }
                    blob.getFile().delete();
                    CMSBinaryContent content = new CMSBinaryContent();
                    content.setName(blob.getFileName());
                    content.setFile(tempFile);
                    content.setMimeType(blob.getMimeType());
                    content.setFileSize(Long.valueOf(cout.getByteCount()));
                    return content;
                }
            }
            throw new NuxeoException(3);
        }

        @Override
        public String getId() {
            return "CMSBinaryContentCommand" + this.path + "/" + this.content;
        }
    }

    private static class CMSBinaryContentCommand
    implements INuxeoCommand {
        String path;
        String fileIndex;

        public CMSBinaryContentCommand(String path, String fileIndex) {
            this.path = path;
            this.fileIndex = fileIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object execute(Session session) throws Exception {
            Document doc = (Document)session.newRequest("Document.Fetch").setHeader("X-NXDocumentProperties", "*").set("value", (Object)this.path).execute();
            Blob blob = null;
            try {
                blob = (Blob)session.newRequest("Blob.Get").setInput((OperationInput)doc).set("xpath", (Object)("files:files/item[" + this.fileIndex + "]/file")).execute();
            }
            catch (Exception e) {
                throw new NuxeoException(3);
            }
            InputStream in = blob.getStream();
            File tempFile = File.createTempFile("tempFile3", ".tmp");
            CountingOutputStream cout = new CountingOutputStream((OutputStream)new FileOutputStream(tempFile));
            try {
                byte[] b = new byte[4096];
                int i = -1;
                while ((i = in.read(b)) != -1) {
                    cout.write(b, 0, i);
                }
                cout.flush();
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((OutputStream)cout);
            }
            CMSBinaryContent content = new CMSBinaryContent();
            content.setName(blob.getFileName());
            content.setFile(tempFile);
            content.setMimeType(blob.getMimeType());
            content.setFileSize(Long.valueOf(cout.getByteCount()));
            return content;
        }

        @Override
        public String getId() {
            return "CMSBinaryContentCommand" + this.path + "/" + this.fileIndex;
        }
    }
}

