/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api;

import javax.portlet.PortletRequest;
import org.apache.commons.lang.BooleanUtils;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.Window;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSServiceCtx;

public abstract class ContextualizationHelper {
    public static String getLivePath(String path) {
        String result = path;
        if (path.endsWith(".proxy")) {
            result = result.substring(0, result.length() - 6);
        }
        return result;
    }

    public static boolean isCurrentDocContextualized(CMSServiceCtx cmsContext) {
        boolean contextualized;
        if (cmsContext == null) {
            contextualized = false;
        } else {
            PortletRequest request = cmsContext.getRequest();
            contextualized = ContextualizationHelper.isCurrentDocContextualized(request);
        }
        return contextualized;
    }

    public static boolean isCurrentDocContextualized(PortalControllerContext portalControllerContext) {
        boolean contextualized;
        if (portalControllerContext == null) {
            contextualized = false;
        } else {
            PortletRequest request = portalControllerContext.getRequest();
            contextualized = ContextualizationHelper.isCurrentDocContextualized(request);
        }
        return contextualized;
    }

    public static boolean isCurrentDocContextualized(PortletRequest request) {
        boolean contextualized;
        Window window = request == null ? null : (Window)request.getAttribute("osivia.window");
        if (window == null) {
            contextualized = false;
        } else if ("1".equals(window.getDeclaredProperty("osivia.cms.contextualization"))) {
            contextualized = true;
        } else {
            Boolean forceContextualization = (Boolean)request.getAttribute("osivia.cms.menuBar.forceContextualization");
            contextualized = BooleanUtils.isTrue((Boolean)forceContextualization);
        }
        return contextualized;
    }

    public static Page getCurrentPage(CMSServiceCtx cmsCtx) throws CMSException {
        Window window = (Window)cmsCtx.getRequest().getAttribute("osivia.window");
        if (window != null) {
            return window.getPage();
        }
        return null;
    }
}

