/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api.domain;

import fr.toutatice.portail.cms.nuxeo.api.Customizable;
import fr.toutatice.portail.cms.nuxeo.api.avatar.AvatarModule;
import fr.toutatice.portail.cms.nuxeo.api.domain.CustomizedJsp;
import fr.toutatice.portail.cms.nuxeo.api.domain.EditableWindow;
import fr.toutatice.portail.cms.nuxeo.api.domain.FragmentType;
import fr.toutatice.portail.cms.nuxeo.api.domain.INavigationAdapterModule;
import fr.toutatice.portail.cms.nuxeo.api.domain.ListTemplate;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilter;
import fr.toutatice.portail.cms.nuxeo.api.portlet.IPortletModule;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletException;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.customization.CustomizationModuleMetadatas;
import org.osivia.portal.api.customization.ICustomizationModule;
import org.osivia.portal.api.customization.ICustomizationModulesRepository;
import org.osivia.portal.api.editor.EditorModule;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.menubar.MenubarModule;
import org.osivia.portal.api.player.IPlayerModule;
import org.osivia.portal.api.portlet.PortalGenericPortlet;
import org.osivia.portal.api.set.SetType;
import org.osivia.portal.api.statistics.StatisticsModule;
import org.osivia.portal.api.taskbar.ITaskbarService;
import org.osivia.portal.api.taskbar.TaskbarFactory;
import org.osivia.portal.api.taskbar.TaskbarItems;
import org.osivia.portal.api.tasks.TaskModule;
import org.osivia.portal.api.theming.TabGroup;
import org.osivia.portal.api.theming.TemplateAdapter;
import org.osivia.portal.core.cms.DomainContextualization;

public abstract class AbstractPluginPortlet
extends PortalGenericPortlet
implements ICustomizationModule {
    public static final int DEFAULT_DEPLOYMENT_ORDER = 100;
    private final ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
    private final ITaskbarService taskbarService = (ITaskbarService)Locator.getService(ITaskbarService.class);
    private CustomizationModuleMetadatas metadatas;
    private ICustomizationModulesRepository repository;

    public int getOrder() {
        return 100;
    }

    public void init() throws PortletException {
        super.init();
        this.metadatas = new CustomizationModuleMetadatas();
        this.metadatas.setName(this.getPluginName());
        this.metadatas.setModule((ICustomizationModule)this);
        this.metadatas.setCustomizationIDs(Arrays.asList("osivia.customizer.cms.id"));
        this.metadatas.setOrder(this.getOrder());
        this.repository = (ICustomizationModulesRepository)Locator.getService(ICustomizationModulesRepository.class);
        this.repository.register(this.metadatas);
    }

    protected abstract String getPluginName();

    public void destroy() {
        super.destroy();
        this.repository.unregister(this.metadatas);
    }

    public void parseJavaServerPages(String directoryPath, File directory, Map<String, CustomizedJsp> customizedPages) {
        File[] children;
        for (File child : children = directory.listFiles()) {
            if (child.isFile()) {
                String absolutePath = child.getAbsolutePath();
                String relativePath = StringUtils.removeStart((String)absolutePath, (String)directoryPath);
                CustomizedJsp customizedPage = new CustomizedJsp(absolutePath, this.classLoader);
                customizedPages.put(relativePath, customizedPage);
            }
            if (!child.isDirectory()) continue;
            this.parseJavaServerPages(directoryPath, child, customizedPages);
        }
    }

    public void customize(CustomizationContext context) {
        String directoryPath;
        File directory;
        Map attributes = context.getAttributes();
        CLASS_LOADER_CONTEXT.set(this.classLoader);
        this.customizeCMSProperties(context);
        ConcurrentHashMap<String, CustomizedJsp> customizedPages = (ConcurrentHashMap<String, CustomizedJsp>)attributes.get(Customizable.JSP.toString());
        if (customizedPages == null) {
            customizedPages = new ConcurrentHashMap<String, CustomizedJsp>();
            attributes.put(Customizable.JSP.toString(), customizedPages);
        }
        if ((directory = new File(directoryPath = this.getPortletContext().getRealPath("/WEB-INF/custom/jsp"))).exists()) {
            this.parseJavaServerPages(directoryPath, directory, customizedPages);
        }
    }

    protected abstract void customizeCMSProperties(CustomizationContext var1);

    protected List<IPlayerModule> getPlayers(CustomizationContext context) {
        Map attributes = context.getAttributes();
        ArrayList players = (ArrayList)attributes.get(Customizable.PLAYER.toString());
        if (players == null) {
            players = new ArrayList();
            attributes.put(Customizable.PLAYER.toString(), players);
        }
        return players;
    }

    protected Map<String, ListTemplate> getListTemplates(CustomizationContext context) {
        Map attributes = context.getAttributes();
        ConcurrentHashMap templates = (ConcurrentHashMap)attributes.get(Customizable.LIST_TEMPLATE.toString() + context.getLocale());
        if (templates == null) {
            templates = new ConcurrentHashMap();
            attributes.put(Customizable.LIST_TEMPLATE.toString() + context.getLocale(), templates);
        }
        return templates;
    }

    protected Map<String, DocumentType> getDocTypes(CustomizationContext context) {
        Map attributes = context.getAttributes();
        ConcurrentHashMap docTypes = (ConcurrentHashMap)attributes.get(Customizable.DOC_TYPE.toString());
        if (docTypes == null) {
            docTypes = new ConcurrentHashMap();
            attributes.put(Customizable.DOC_TYPE.toString(), docTypes);
        }
        return docTypes;
    }

    protected void addSubtype(CustomizationContext context, String parentDocTypeName, String childDocTypeName) {
        Map<String, DocumentType> docTypes = this.getDocTypes(context);
        DocumentType parentDocType = docTypes.get(parentDocTypeName);
        if (parentDocType != null) {
            parentDocType.getSubtypes().add(childDocTypeName);
        }
    }

    protected List<FragmentType> getFragmentTypes(CustomizationContext context) {
        Map attributes = context.getAttributes();
        ArrayList fragmentTypes = (ArrayList)attributes.get(Customizable.FRAGMENT.toString() + context.getLocale());
        if (fragmentTypes == null) {
            fragmentTypes = new ArrayList();
            attributes.put(Customizable.FRAGMENT.toString() + context.getLocale(), fragmentTypes);
        }
        return fragmentTypes;
    }

    protected Map<String, EditableWindow> getEditableWindows(CustomizationContext context) {
        Map attributes = context.getAttributes();
        ConcurrentHashMap ew = (ConcurrentHashMap)attributes.get(Customizable.EDITABLE_WINDOW.toString() + context.getLocale());
        if (ew == null) {
            ew = new ConcurrentHashMap();
            attributes.put(Customizable.EDITABLE_WINDOW.toString() + context.getLocale(), ew);
        }
        return ew;
    }

    protected List<MenubarModule> getMenubarModules(CustomizationContext context) {
        Map attributes = context.getAttributes();
        ArrayList menubars = (ArrayList)attributes.get(Customizable.MENUBAR.toString());
        if (menubars == null) {
            menubars = new ArrayList();
            attributes.put(Customizable.MENUBAR.toString(), menubars);
        }
        return menubars;
    }

    protected SortedMap<String, String> getMenuTemplates(CustomizationContext context) {
        Map attributes = context.getAttributes();
        TreeMap templates = (TreeMap)attributes.get(Customizable.MENU_TEMPLATE.toString() + context.getLocale());
        if (templates == null) {
            templates = new TreeMap();
            attributes.put(Customizable.MENU_TEMPLATE.toString() + context.getLocale(), templates);
        }
        return templates;
    }

    protected List<INavigationAdapterModule> getNavigationAdapters(CustomizationContext context) {
        Map attributes = context.getAttributes();
        ArrayList adapters = (ArrayList)attributes.get(Customizable.NAVIGATION_ADAPTERS.toString());
        if (adapters == null) {
            adapters = new ArrayList();
            attributes.put(Customizable.NAVIGATION_ADAPTERS.toString(), adapters);
        }
        return adapters;
    }

    protected List<DomainContextualization> getDomainContextualizations(CustomizationContext context) {
        Map attributes = context.getAttributes();
        ArrayList contextualizations = (ArrayList)attributes.get(Customizable.DOMAIN_CONTEXTUALIZATION.toString());
        if (contextualizations == null) {
            contextualizations = new ArrayList();
            attributes.put(Customizable.DOMAIN_CONTEXTUALIZATION.toString(), contextualizations);
        }
        return contextualizations;
    }

    protected Map<String, TabGroup> getTabGroups(CustomizationContext context) {
        Map attributes = context.getAttributes();
        ConcurrentHashMap tabGroups = (ConcurrentHashMap)attributes.get(Customizable.TAB_GROUPS.toString());
        if (tabGroups == null) {
            tabGroups = new ConcurrentHashMap();
            attributes.put(Customizable.TAB_GROUPS.toString(), tabGroups);
        }
        return tabGroups;
    }

    protected TaskbarItems getTaskbarItems(CustomizationContext context) {
        Map attributes = context.getAttributes();
        TaskbarItems taskbarItems = (TaskbarItems)attributes.get(Customizable.TASKBAR_ITEMS.toString());
        if (taskbarItems == null) {
            TaskbarFactory factory = this.taskbarService.getFactory();
            taskbarItems = factory.createTaskbarItems();
            attributes.put(Customizable.TASKBAR_ITEMS.toString(), taskbarItems);
        }
        return taskbarItems;
    }

    protected List<TemplateAdapter> getTemplateAdapters(CustomizationContext context) {
        Map attributes = context.getAttributes();
        ArrayList templateAdapters = (ArrayList)attributes.get(Customizable.TEMPLATE_ADAPTERS.toString());
        if (templateAdapters == null) {
            templateAdapters = new ArrayList();
            attributes.put(Customizable.TEMPLATE_ADAPTERS.toString(), templateAdapters);
        }
        return templateAdapters;
    }

    protected Map<String, FormFilter> getFormFilters(CustomizationContext context) {
        Map attributes = context.getAttributes();
        ConcurrentHashMap filters = (ConcurrentHashMap)attributes.get(Customizable.FORM_FILTERS.toString());
        if (filters == null) {
            filters = new ConcurrentHashMap();
            attributes.put(Customizable.FORM_FILTERS.toString(), filters);
        }
        return filters;
    }

    protected Map<String, SetType> getSetTypes(CustomizationContext context) {
        Map attributes = context.getAttributes();
        ConcurrentHashMap setTypes = (ConcurrentHashMap)attributes.get(Customizable.SET_TYPES.toString());
        if (setTypes == null) {
            setTypes = new ConcurrentHashMap();
            attributes.put(Customizable.SET_TYPES.toString(), setTypes);
        }
        return setTypes;
    }

    protected List<TaskModule> getTaskModules(CustomizationContext customizationContext) {
        Map attributes = customizationContext.getAttributes();
        ArrayList taskModules = (ArrayList)attributes.get(Customizable.TASK_MODULES.toString());
        if (taskModules == null) {
            taskModules = new ArrayList();
            attributes.put(Customizable.TASK_MODULES.toString(), taskModules);
        }
        return taskModules;
    }

    protected List<IPortletModule> getDocumentModules(CustomizationContext customizationContext, String type) {
        ArrayList modules;
        Map attributes = customizationContext.getAttributes();
        ConcurrentHashMap value = (ConcurrentHashMap)attributes.get(Customizable.DOCUMENT_MODULES.toString());
        if (value == null) {
            value = new ConcurrentHashMap();
            attributes.put(Customizable.DOCUMENT_MODULES.toString(), value);
        }
        if ((modules = (ArrayList)value.get(type)) == null) {
            modules = new ArrayList();
            value.put(type, modules);
        }
        return modules;
    }

    protected List<StatisticsModule> getStatisticsModules(CustomizationContext customizationContext) {
        Map attributes = customizationContext.getAttributes();
        ArrayList modules = (ArrayList)attributes.get(Customizable.STATISTICS_MODULES.toString());
        if (modules == null) {
            modules = new ArrayList();
            attributes.put(Customizable.STATISTICS_MODULES.toString(), modules);
        }
        return modules;
    }

    protected List<EditorModule> getEditorModules(CustomizationContext customizationContext) {
        Map attributes = customizationContext.getAttributes();
        ArrayList modules = (ArrayList)attributes.get(Customizable.EDITOR_MODULES.toString());
        if (modules == null) {
            modules = new ArrayList();
            attributes.put(Customizable.EDITOR_MODULES.toString(), modules);
        }
        return modules;
    }

    protected List<AvatarModule> getAvatarModules(CustomizationContext customizationContext) {
        Map attributes = customizationContext.getAttributes();
        ArrayList modules = (ArrayList)attributes.get(Customizable.AVATAR_MODULES.toString());
        if (modules == null) {
            modules = new ArrayList();
            attributes.put(Customizable.AVATAR_MODULES.toString(), modules);
        }
        return modules;
    }

    public ITaskbarService getTaskbarService() {
        return this.taskbarService;
    }
}

