/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.widget.google.provider;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.portal.common.io.IOTools;
import org.jboss.portal.common.net.URLTools;
import org.jboss.portal.widget.WidgetQuery;
import org.jboss.portal.widget.exceptions.WidgetException;
import org.jboss.portal.widget.google.directory.GGWidgetDirectoryFactory;
import org.jboss.portal.widget.google.metadata.GGWidgetMetaData;
import org.jboss.portal.widget.google.provider.GGQueryResult;
import org.jboss.portal.widget.google.provider.GGQueryResultEntry;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;

public class GGQueryResultBuilder {
    private static final Logger log = Logger.getLogger(GGQueryResultBuilder.class);
    public static final String GHAPI_URI = "http://www.google.com/apis/homepage";
    private final URL url;

    public GGQueryResultBuilder(WidgetQuery query) throws MalformedURLException {
        if (query == null) {
            throw new IllegalArgumentException();
        }
        this.url = query.buildQueryURL();
    }

    public GGQueryResultBuilder(URL url) {
        if (url == null) {
            throw new IllegalArgumentException();
        }
        this.url = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GGQueryResult build(int connectionTimeout) throws WidgetException {
        try {
            byte[] bytes;
            long millis = System.currentTimeMillis();
            if ("http".equals(this.url.getProtocol())) {
                bytes = URLTools.getContent((URL)this.url, (int)connectionTimeout, (int)connectionTimeout);
            } else {
                InputStream in = this.url.openStream();
                try {
                    bytes = IOTools.getBytes((InputStream)in);
                }
                finally {
                    IOTools.safeClose((Closeable)in);
                }
            }
            if (bytes == null) {
                throw new WidgetException("Cannot retrieve url: " + this.url + " - you can try to increase the connectionTimeout");
            }
            String string = new String(bytes);
            List data = null;
            Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
            GGWidgetDirectoryFactory factory = new GGWidgetDirectoryFactory();
            try {
                data = (List)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(string.getBytes("UTF-8")), (ObjectModelFactory)factory, null);
            }
            catch (JBossXBException e) {
                String string2 = string.replace("& ", "&amp; ");
                unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
                data = (List)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(string2.getBytes("UTF-8")), (ObjectModelFactory)factory, null);
            }
            ArrayList<GGQueryResultEntry> entries = new ArrayList<GGQueryResultEntry>();
            for (GGWidgetMetaData md : data) {
                GGQueryResultEntry entry = new GGQueryResultEntry(md);
                entries.add(entry);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Fetchting directory took: " + NumberFormat.getInstance().format((double)(System.currentTimeMillis() - millis) / 1000.0)));
            }
            return new GGQueryResult(entries);
        }
        catch (SocketTimeoutException e) {
            throw new WidgetException("Netvibes directory query failed due to timeout. Try to increase connectionTimeout initial parameter; ", (Throwable)e);
        }
        catch (JBossXBException e) {
            throw new WidgetException("Failed to parse directory response.", e.getCause());
        }
        catch (IOException e) {
            throw new WidgetException("Failed to perform directory lookup.", (Throwable)e);
        }
    }
}

