/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.tx;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aspects.tx.ClientTxPropagationInterceptor;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionManagerLocator;
import org.jboss.tm.TransactionPropagationContextFactory;
import org.jboss.tm.TransactionPropagationContextUtil;

public class TxPropagationInterceptor
implements Interceptor {
    private TransactionManager tm;
    private static final Logger log = Logger.getLogger((Class)TxPropagationInterceptor.class);

    public TxPropagationInterceptor(TransactionManager tm) {
        this.tm = tm;
    }

    public TxPropagationInterceptor() {
        this.tm = TransactionManagerLocator.getInstance().locate();
    }

    public String getName() {
        return "TxPropagationInterceptor";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        Object importedTpc = invocation.getMetaData((Object)ClientTxPropagationInterceptor.TRANSACTION_PROPAGATION_CONTEXT, (Object)ClientTxPropagationInterceptor.TRANSACTION_PROPAGATION_CONTEXT);
        if (importedTpc != null) {
            Transaction tx = this.tm.getTransaction();
            if (tx != null) {
                TransactionPropagationContextFactory tpcFactory = TransactionPropagationContextUtil.getTPCFactory();
                Object tpc = null;
                if (tpcFactory != null) {
                    tpc = tpcFactory.getTransactionPropagationContext();
                }
                if (importedTpc.equals(tpc)) {
                    return invocation.invokeNext();
                }
                throw new RuntimeException("cannot import a transaction context when a transaction is already associated with the thread");
            }
            Transaction importedTx = TransactionPropagationContextUtil.getTPCImporter().importTransactionPropagationContext(importedTpc);
            this.tm.resume(importedTx);
            try {
                Object object = invocation.invokeNext();
                return object;
            }
            finally {
                this.tm.suspend();
            }
        }
        return invocation.invokeNext();
    }
}

