/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model.instance.command.render;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.common.NotYetImplemented;
import org.jboss.portal.common.util.MultiValuedPropertyMap;
import org.jboss.portal.core.controller.ControllerException;
import org.jboss.portal.core.controller.ControllerResponse;
import org.jboss.portal.core.controller.command.info.CommandInfo;
import org.jboss.portal.core.controller.portlet.PortletContextFactory;
import org.jboss.portal.core.controller.portlet.PortletInvocationFactory;
import org.jboss.portal.core.model.instance.InvokePortletInstanceCommandFactory;
import org.jboss.portal.core.model.instance.command.PortletInstanceCommand;
import org.jboss.portal.core.theme.PageRendition;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.StateString;
import org.jboss.portal.portlet.invocation.PortletInvocation;
import org.jboss.portal.portlet.invocation.RenderInvocation;
import org.jboss.portal.portlet.invocation.response.ErrorResponse;
import org.jboss.portal.portlet.invocation.response.FragmentResponse;
import org.jboss.portal.portlet.invocation.response.PortletInvocationResponse;
import org.jboss.portal.portlet.invocation.response.ResponseProperties;
import org.jboss.portal.theme.LayoutService;
import org.jboss.portal.theme.PageService;
import org.jboss.portal.theme.PortalLayout;
import org.jboss.portal.theme.page.PageResult;
import org.jboss.portal.theme.page.WindowContext;
import org.jboss.portal.theme.page.WindowResult;

public class RenderPortletInstanceCommand
extends PortletInstanceCommand {
    public RenderPortletInstanceCommand(String instanceId, StateString navigationalState) {
        super(instanceId, navigationalState);
    }

    public CommandInfo getInfo() {
        return null;
    }

    public ControllerResponse execute() throws ControllerException {
        try {
            String content;
            PortletContextFactory pcf1 = new PortletContextFactory(this.context);
            InvokePortletInstanceCommandFactory pcf2 = new InvokePortletInstanceCommandFactory(this.instanceId);
            RenderInvocation render = PortletInvocationFactory.createRender(this.context, Mode.VIEW, WindowState.MAXIMIZED, this.navigationalState, pcf1, pcf2);
            PortletInvocationResponse response = this.instance.invoke((PortletInvocation)render);
            List headElements = null;
            if (response instanceof FragmentResponse) {
                FragmentResponse fragment = (FragmentResponse)response;
                content = fragment.getContent();
                ResponseProperties properties = fragment.getProperties();
                if (properties != null) {
                    MultiValuedPropertyMap headers = properties.getMarkupHeaders();
                    headElements = headers.getValues("javax.portlet.markup.head.element");
                }
            } else if (response instanceof ErrorResponse) {
                content = ((ErrorResponse)response).toHTML();
            } else {
                throw new NotYetImplemented();
            }
            PageService ps = this.context.getController().getPageService();
            LayoutService ls = ps.getLayoutService();
            PortalLayout layout = ls.getLayout("generic", true);
            HashMap<String, String> pageProperties = new HashMap<String, String>();
            pageProperties.put("theme.renderSetId", "divRenderer");
            pageProperties.put("theme.id", "renewal");
            PageResult result = new PageResult("BILTO", pageProperties);
            HashMap<String, String> windowProps = new HashMap<String, String>();
            windowProps.put("theme.windowRendererId", "emptyRenderer");
            windowProps.put("theme.decorationRendererId", "emptyRenderer");
            windowProps.put("theme.portletRendererId", "emptyRenderer");
            WindowResult res = new WindowResult("", content, Collections.EMPTY_MAP, windowProps, headElements, WindowState.MAXIMIZED, Mode.VIEW);
            WindowContext blah = new WindowContext("BILTO", "maximized", "0", res);
            result.addWindowContext(blah);
            return new PageRendition(layout, null, result, ps);
        }
        catch (PortletInvokerException e) {
            throw new ControllerException(e);
        }
    }
}

