/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model.portal.command;

import org.jboss.portal.core.controller.AccessDeniedException;
import org.jboss.portal.core.controller.ControllerCommand;
import org.jboss.portal.core.controller.NoSuchResourceException;
import org.jboss.portal.core.controller.SecurityException;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.PortalObjectPermission;
import org.jboss.portal.security.PortalPermission;
import org.jboss.portal.security.spi.auth.PortalAuthorizationManager;
import org.osivia.portal.core.dynamic.ITemplatePortalObject;

public abstract class PortalObjectCommand
extends ControllerCommand {
    protected final PortalObjectId targetId;
    protected PortalObject target;
    protected boolean dashboard;

    protected PortalObjectCommand(PortalObjectId targetId) {
        if (targetId == null) {
            throw new IllegalArgumentException();
        }
        this.targetId = targetId;
        this.dashboard = "dashboard".equals(targetId.getNamespace());
    }

    public final PortalObjectId getTargetId() {
        return this.targetId;
    }

    public void acquireResources() throws NoSuchResourceException {
        this.target = this.context.getController().getPortalObjectContainer().getObject(this.targetId);
        if (this.target == null) {
            throw new NoSuchResourceException(this.targetId.toString());
        }
    }

    public void enforceSecurity(PortalAuthorizationManager pam) throws SecurityException {
        PortalObjectId id;
        PortalObjectPermission perm;
        PortalObject target = this.getTarget();
        if (target instanceof ITemplatePortalObject) {
            while ((target = target.getParent()) instanceof ITemplatePortalObject) {
            }
        }
        if (!pam.checkPermission((PortalPermission)(perm = new PortalObjectPermission(id = target.getId(), 1)))) {
            throw new AccessDeniedException(id.toString(), "View permission not granted");
        }
    }

    public final PortalObject getTarget() {
        return this.target;
    }

    public boolean isDashboard() {
        return this.dashboard;
    }
}

