/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.controller;

import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.common.util.ParameterMap;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.StateString;
import org.jboss.portal.portlet.controller.EventControllerContextSafeInvoker;
import org.jboss.portal.portlet.controller.EventPhaseContextImpl;
import org.jboss.portal.portlet.controller.EventProduction;
import org.jboss.portal.portlet.controller.PortletController;
import org.jboss.portal.portlet.controller.PortletControllerContext;
import org.jboss.portal.portlet.controller.RequestHandler;
import org.jboss.portal.portlet.controller.event.EventControllerContext;
import org.jboss.portal.portlet.controller.event.PortletWindowEvent;
import org.jboss.portal.portlet.controller.request.PortletActionRequest;
import org.jboss.portal.portlet.controller.request.PortletRenderRequest;
import org.jboss.portal.portlet.controller.request.PortletRequest;
import org.jboss.portal.portlet.controller.response.ControllerResponse;
import org.jboss.portal.portlet.controller.response.PageUpdateResponse;
import org.jboss.portal.portlet.controller.response.PortletResponse;
import org.jboss.portal.portlet.controller.state.PortletPageNavigationalState;
import org.jboss.portal.portlet.controller.state.PortletWindowNavigationalState;
import org.jboss.portal.portlet.controller.state.StateControllerContext;
import org.jboss.portal.portlet.info.PortletInfo;
import org.jboss.portal.portlet.invocation.ActionInvocation;
import org.jboss.portal.portlet.invocation.EventInvocation;
import org.jboss.portal.portlet.invocation.response.PortletInvocationResponse;
import org.jboss.portal.portlet.invocation.response.ResponseProperties;
import org.jboss.portal.portlet.invocation.response.UpdateNavigationalStateResponse;
import org.jboss.portal.portlet.spi.PortletInvocationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PortletRequestHandler
extends RequestHandler<PortletRequest> {
    private static final EventControllerContextSafeInvoker safeInvoker = new EventControllerContextSafeInvoker();

    public PortletRequestHandler(PortletController controller) {
        super(PortletRequest.class, controller);
    }

    @Override
    ControllerResponse processResponse(PortletControllerContext context, PortletRequest portletRequest, PortletInvocationResponse response) throws PortletInvokerException {
        StateControllerContext stateContext = context.getStateControllerContext();
        PortletPageNavigationalState pageNavigationalState = portletRequest.getPageNavigationalState();
        pageNavigationalState = pageNavigationalState == null ? stateContext.createPortletPageNavigationalState(true) : stateContext.clonePortletPageNavigationalState(pageNavigationalState, true);
        ResponseProperties requestProperties = new ResponseProperties();
        if (response instanceof UpdateNavigationalStateResponse) {
            PortletWindowEvent producedEvent;
            UpdateNavigationalStateResponse updateResponse = (UpdateNavigationalStateResponse)response;
            this.updateNavigationalState(context, portletRequest.getWindowId(), updateResponse, pageNavigationalState);
            ResponseProperties update = updateResponse.getProperties();
            if (update != null) {
                requestProperties.append(update);
            }
            EventControllerContext eventCC = context.getEventControllerContext();
            UpdateNavigationalStateResponse stateResponse = (UpdateNavigationalStateResponse)response;
            EventPhaseContextImpl phaseContext = new EventPhaseContextImpl(log);
            for (UpdateNavigationalStateResponse.Event portletEvent : stateResponse.getEvents()) {
                producedEvent = new PortletWindowEvent(portletEvent.getName(), portletEvent.getPayload(), portletRequest.getWindowId());
                phaseContext.producedEvents.add(new EventProduction(null, producedEvent));
            }
            int eventDistributionStatus = 0;
            while (phaseContext.producedEvents.size() > 0) {
                EventProduction eventProduction = phaseContext.producedEvents.removeFirst();
                producedEvent = eventProduction.getProducedEvent();
                String producerId = producedEvent.getWindowId();
                PortletInfo producerPortletInfo = context.getPortletInfo(producerId);
                if (producerPortletInfo == null) {
                    log.trace((Object)("Cannot deliver event " + producedEvent + " because the producer does not have portlet info"));
                    safeInvoker.eventDiscarded(eventCC, phaseContext, producedEvent, 1);
                    continue;
                }
                if (!this.controller.getDistributeNonProduceableEvents() && !producerPortletInfo.getEventing().getProducedEvents().containsKey(producedEvent.getName())) {
                    log.trace((Object)("Cannot deliver event " + producedEvent + " because the producer of the event does not produce the event name"));
                    safeInvoker.eventDiscarded(eventCC, phaseContext, producedEvent, 4);
                    continue;
                }
                int producedEventThreshold = this.controller.getProducedEventThreshold();
                if (producedEventThreshold >= 0 && phaseContext.producedEventSize + 1 > producedEventThreshold) {
                    log.trace((Object)"Event distribution interrupted because the maximum number of produced event is reached");
                    eventDistributionStatus = 2;
                    safeInvoker.eventDiscarded(eventCC, phaseContext, producedEvent, 6);
                    break;
                }
                phaseContext.mode = 1;
                if (!safeInvoker.eventProduced(eventCC, phaseContext, eventProduction.getConsumedEvent(), producedEvent)) continue;
                if (phaseContext.mode == 2) {
                    log.trace((Object)"Event distribution interrupted by controller context");
                    eventDistributionStatus = 1;
                    break;
                }
                while (phaseContext.toConsumeEvents.size() > 0) {
                    PortletInvocationResponse eventResponse;
                    PortletWindowEvent toConsumeEvent = phaseContext.toConsumeEvents.removeFirst();
                    String consumedId = toConsumeEvent.getWindowId();
                    PortletInfo consumerPortletInfo = context.getPortletInfo(consumedId);
                    if (consumerPortletInfo == null) {
                        log.trace((Object)("Cannot deliver event " + producedEvent + " because the consumer of the event does not have a portlet info"));
                        safeInvoker.eventDiscarded(eventCC, phaseContext, toConsumeEvent, 3);
                        continue;
                    }
                    if (!this.controller.getDistributeNonConsumableEvents() && !consumerPortletInfo.getEventing().getConsumedEvents().containsKey(toConsumeEvent.getName())) {
                        log.trace((Object)("Cannot deliver event " + producedEvent + " because the consumer of the event does not accept the event name"));
                        safeInvoker.eventDiscarded(eventCC, phaseContext, toConsumeEvent, 4);
                        continue;
                    }
                    int consumedEventThreshold = this.controller.getConsumedEventThreshold();
                    if (consumedEventThreshold >= 0 && phaseContext.consumedEventSize + 1 > consumedEventThreshold) {
                        log.trace((Object)"Event distribution interrupted because the maximum number of consumed event is reached");
                        safeInvoker.eventDiscarded(eventCC, phaseContext, toConsumeEvent, 5);
                        eventDistributionStatus = 3;
                        break;
                    }
                    try {
                        eventResponse = this.deliverEvent(context, toConsumeEvent, pageNavigationalState, requestProperties.getCookies());
                    }
                    catch (Exception e) {
                        log.trace((Object)("Event delivery of " + toConsumeEvent + " failed"), (Throwable)e);
                        safeInvoker.eventFailed(eventCC, phaseContext, toConsumeEvent, e);
                        continue;
                    }
                    ++phaseContext.consumedEventSize;
                    if (eventResponse instanceof UpdateNavigationalStateResponse) {
                        UpdateNavigationalStateResponse eventStateResponse = (UpdateNavigationalStateResponse)eventResponse;
                        this.updateNavigationalState(context, toConsumeEvent.getWindowId(), eventStateResponse, pageNavigationalState);
                        for (UpdateNavigationalStateResponse.Event portletEvent : eventStateResponse.getEvents()) {
                            PortletWindowEvent toRouteEvent = new PortletWindowEvent(portletEvent.getName(), portletEvent.getPayload(), toConsumeEvent.getWindowId());
                            phaseContext.producedEvents.add(new EventProduction(toConsumeEvent, toRouteEvent));
                        }
                        ResponseProperties updateProperties = eventStateResponse.getProperties();
                        if (updateProperties != null) {
                            requestProperties.append(updateProperties);
                        }
                    }
                    phaseContext.mode = 0;
                    safeInvoker.eventConsumed(eventCC, phaseContext, toConsumeEvent, eventResponse);
                }
                ++phaseContext.producedEventSize;
            }
            return new PageUpdateResponse(updateResponse, requestProperties, pageNavigationalState, eventDistributionStatus);
        }
        return new PortletResponse(response, 0);
    }

    @Override
    PortletInvocationResponse invoke(PortletControllerContext context, PortletRequest portletRequest) throws PortletInvokerException {
        WindowState windowState;
        if (portletRequest instanceof PortletRenderRequest) {
            PortletRenderRequest portletRenderRequest = (PortletRenderRequest)portletRequest;
            UpdateNavigationalStateResponse updateNavigationalState = new UpdateNavigationalStateResponse();
            updateNavigationalState.setMode(portletRenderRequest.getWindowNavigationalState().getMode());
            updateNavigationalState.setWindowState(portletRenderRequest.getWindowNavigationalState().getWindowState());
            updateNavigationalState.setNavigationalState(portletRenderRequest.getWindowNavigationalState().getPortletNavigationalState());
            updateNavigationalState.setPublicNavigationalStateUpdates(portletRenderRequest.getPublicNavigationalStateChanges());
            return updateNavigationalState;
        }
        PortletActionRequest portletActionRequest = (PortletActionRequest)portletRequest;
        PortletPageNavigationalState pageNavigationalState = portletActionRequest.getPageNavigationalState();
        Mode mode = portletActionRequest.getWindowNavigationalState().getMode();
        if (mode == null) {
            mode = Mode.VIEW;
        }
        if ((windowState = portletActionRequest.getWindowNavigationalState().getWindowState()) == null) {
            windowState = WindowState.NORMAL;
        }
        Map<String, String[]> publicNS = null;
        if (pageNavigationalState != null) {
            publicNS = pageNavigationalState.getPortletPublicNavigationalState(portletRequest.getWindowId());
        }
        PortletInvocationContext portletInvocationContext = context.createPortletInvocationContext(portletRequest.getWindowId(), pageNavigationalState);
        ActionInvocation actionInvocation = new ActionInvocation(portletInvocationContext);
        actionInvocation.setMode(mode);
        actionInvocation.setWindowState(windowState);
        actionInvocation.setNavigationalState(portletActionRequest.getWindowNavigationalState().getPortletNavigationalState());
        actionInvocation.setPublicNavigationalState(publicNS);
        actionInvocation.setInteractionState(portletActionRequest.getInteractionState());
        actionInvocation.setForm(portletActionRequest.getBodyParameters() != null ? ParameterMap.clone(portletActionRequest.getBodyParameters()) : null);
        return context.invoke(actionInvocation);
    }

    private PortletInvocationResponse deliverEvent(PortletControllerContext context, PortletWindowEvent event, PortletPageNavigationalState pageNavigationalState, List<Cookie> requestCookies) throws PortletInvokerException {
        PortletWindowNavigationalState windowNS = pageNavigationalState.getPortletWindowNavigationalState(event.getWindowId());
        if (windowNS == null) {
            windowNS = new PortletWindowNavigationalState();
        }
        Map<String, String[]> publicNS = pageNavigationalState.getPortletPublicNavigationalState(event.getWindowId());
        PortletInvocationContext portletInvocationContext = context.createPortletInvocationContext(event.getWindowId(), pageNavigationalState);
        EventInvocation eventInvocation = new EventInvocation(portletInvocationContext);
        eventInvocation.setMode(windowNS.getMode());
        eventInvocation.setWindowState(windowNS.getWindowState());
        eventInvocation.setNavigationalState(windowNS.getPortletNavigationalState());
        eventInvocation.setPublicNavigationalState(publicNS);
        eventInvocation.setName(event.getName());
        eventInvocation.setPayload(event.getPayload());
        return context.invoke(requestCookies, eventInvocation);
    }

    private void updateNavigationalState(PortletControllerContext context, String windowId, UpdateNavigationalStateResponse update, PortletPageNavigationalState pageNavigationalState) throws PortletInvokerException {
        PortletWindowNavigationalState windowNS = pageNavigationalState.getPortletWindowNavigationalState(windowId);
        if (windowNS == null) {
            windowNS = new PortletWindowNavigationalState();
        }
        Mode mode = windowNS.getMode();
        if (update.getMode() != null) {
            mode = update.getMode();
        }
        WindowState windowState = windowNS.getWindowState();
        if (update.getWindowState() != null) {
            windowState = update.getWindowState();
        }
        StateString portletNS = windowNS.getPortletNavigationalState();
        if (update.getNavigationalState() != null) {
            portletNS = update.getNavigationalState();
        }
        windowNS = new PortletWindowNavigationalState(portletNS, mode, windowState);
        pageNavigationalState.setPortletWindowNavigationalState(windowId, windowNS);
        Map publicNS = update.getPublicNavigationalStateUpdates();
        if (publicNS != null) {
            pageNavigationalState.setPortletPublicNavigationalState(windowId, publicNS);
        }
    }
}

