/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.security;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.acl.Group;
import java.util.Iterator;
import java.util.Set;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.jboss.security.SimpleGroup;

class SubjectActions {
    SubjectActions() {
    }

    static void addCredentials(Subject subject, PasswordCredential cred) {
        AddCredentialsAction action = new AddCredentialsAction(subject, cred);
        AccessController.doPrivileged(action);
    }

    static void addPrincipals(Subject subject, Principal p) {
        AddPrincipalsAction action = new AddPrincipalsAction(subject, p);
        AccessController.doPrivileged(action);
    }

    static void removeCredentials(Subject subject, ManagedConnectionFactory mcf) {
        RemoveCredentialsAction action = new RemoveCredentialsAction(subject, mcf);
        AccessController.doPrivileged(action);
    }

    static void addRoles(Subject subject, Set runAsRoles) {
        if (System.getSecurityManager() != null) {
            AddRolesActions.PRIVILEGED.addRoles(subject, runAsRoles);
        } else {
            AddRolesActions.NON_PRIVILEGED.addRoles(subject, runAsRoles);
        }
    }

    private static Group addSubjectRoles(Subject theSubject, Set roles) {
        Set<Group> subjectGroups = theSubject.getPrincipals(Group.class);
        Iterator<Object> iter = subjectGroups.iterator();
        SimpleGroup roleGrp = null;
        while (iter.hasNext()) {
            Group grp = iter.next();
            String name = grp.getName();
            if (!name.equals("Roles")) continue;
            roleGrp = grp;
        }
        if (roleGrp == null) {
            roleGrp = new SimpleGroup("Roles");
            theSubject.getPrincipals().add((Principal)roleGrp);
        }
        for (Principal role : roles) {
            roleGrp.addMember(role);
        }
        return roleGrp;
    }

    static class RemoveCredentialsAction
    implements PrivilegedAction {
        Subject subject;
        ManagedConnectionFactory mcf;

        RemoveCredentialsAction(Subject subject, ManagedConnectionFactory mcf) {
            this.subject = subject;
            this.mcf = mcf;
        }

        public Object run() {
            Iterator<Object> i = this.subject.getPrivateCredentials().iterator();
            while (i.hasNext()) {
                PasswordCredential pc;
                Object o = i.next();
                if (!(o instanceof PasswordCredential) || (pc = (PasswordCredential)o).getManagedConnectionFactory() != this.mcf) continue;
                i.remove();
            }
            return null;
        }
    }

    static class AddPrincipalsAction
    implements PrivilegedAction {
        Subject subject;
        Principal p;

        AddPrincipalsAction(Subject subject, Principal p) {
            this.subject = subject;
            this.p = p;
        }

        public Object run() {
            this.subject.getPrincipals().add(this.p);
            return null;
        }
    }

    static class AddCredentialsAction
    implements PrivilegedAction {
        Subject subject;
        PasswordCredential cred;

        AddCredentialsAction(Subject subject, PasswordCredential cred) {
            this.subject = subject;
            this.cred = cred;
        }

        public Object run() {
            this.subject.getPrivateCredentials().add(this.cred);
            return null;
        }
    }

    static interface AddRolesActions {
        public static final AddRolesActions PRIVILEGED = new AddRolesActions(){

            public void addRoles(final Subject subject, final Set roles) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        SubjectActions.addSubjectRoles(subject, roles);
                        return null;
                    }
                });
            }
        };
        public static final AddRolesActions NON_PRIVILEGED = new AddRolesActions(){

            public void addRoles(Subject subject, Set roles) {
                SubjectActions.addSubjectRoles(subject, roles);
            }
        };

        public void addRoles(Subject var1, Set var2);
    }
}

