/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.taglib.portal.tag;

import java.io.IOException;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.apache.commons.lang.StringUtils;
import org.jboss.portal.portlet.invocation.PortletInvocation;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;

public class TranslationTag
extends SimpleTagSupport {
    private static final String INTERNATIONALIZATION_SERVICE_ATTRIBUTE_NAME = "osivia.internationalization.service";
    private static final String SEPARATOR = ",";
    private String key;
    private String args;

    public void doTag() throws JspException, IOException {
        PageContext pageContext = (PageContext)this.getJspContext();
        Locale locale = pageContext.getRequest().getLocale();
        IInternationalizationService internationalizationService = this.getInternationalizationService(pageContext);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader customizedClassLoader = this.getCustomizedClassLoader(pageContext);
        Object[] arguments = StringUtils.split((String)this.args, (String)SEPARATOR);
        String property = internationalizationService.getString(this.key, locale, classLoader, customizedClassLoader, arguments);
        JspWriter out = pageContext.getOut();
        out.write(property);
    }

    private IInternationalizationService getInternationalizationService(PageContext pageContext) {
        IInternationalizationService internationalizationService = (IInternationalizationService)pageContext.getAttribute(INTERNATIONALIZATION_SERVICE_ATTRIBUTE_NAME, 2);
        if (internationalizationService == null) {
            internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
            pageContext.setAttribute(INTERNATIONALIZATION_SERVICE_ATTRIBUTE_NAME, (Object)internationalizationService, 2);
        }
        return internationalizationService;
    }

    private ClassLoader getCustomizedClassLoader(PageContext pageContext) {
        ClassLoader customizedClassLoader = null;
        PortletInvocation invocation = (PortletInvocation)pageContext.getRequest().getAttribute("org.jboss.portal.attribute.component_invocation");
        if (invocation != null) {
            PortletRequest request = (PortletRequest)invocation.getDispatchedRequest().getAttribute("javax.portlet.request");
            customizedClassLoader = (ClassLoader)request.getAttribute("osivia.customizer.cms.jsp.classloader");
        }
        return customizedClassLoader;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setArgs(String args) {
        this.args = args;
    }
}

