/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.engines.javascript;

import org.apache.bsf.BSFException;
import org.apache.bsf.debug.util.DebugLog;
import org.apache.bsf.engines.javascript.BreakPoint;
import org.apache.bsf.engines.javascript.FnOrScript;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.debug.DebuggableScript;

public class CompilationUnit {
    FnOrScript m_fnOrScript;
    int m_firstLine;
    int m_lineCount;
    String m_fnName;
    DebuggableScript m_dbgScript;
    int[] m_validBrkptLines;

    public CompilationUnit(FnOrScript fnOrScript, DebuggableScript debuggableScript) {
        NativeFunction nativeFunction;
        String string;
        this.m_fnOrScript = fnOrScript;
        this.m_dbgScript = debuggableScript;
        try {
            this.m_validBrkptLines = debuggableScript.getLineNumbers();
            this.m_firstLine = 99999;
            int n = 0;
            for (int i = 0; i < this.m_validBrkptLines.length; ++i) {
                int n2 = this.m_validBrkptLines[i];
                if (this.m_firstLine > n2) {
                    this.m_firstLine = n2;
                }
                if (n >= n2) continue;
                n = n2;
            }
            this.m_lineCount = n - this.m_firstLine + 1;
        }
        catch (Throwable throwable) {
            DebugLog.stderrPrintln("\nWarning: can't get valid line numbers for breakpoints.", 2);
            this.m_validBrkptLines = null;
        }
        Scriptable scriptable = debuggableScript.getScriptable();
        if (scriptable instanceof NativeFunction && (string = (nativeFunction = (NativeFunction)scriptable).getFunctionName()).length() > 0 && !string.equals("anonymous")) {
            this.m_fnName = string;
        }
    }

    boolean contains(int n) {
        return this.m_firstLine <= n && n < this.m_firstLine + this.m_lineCount;
    }

    boolean contains(BreakPoint breakPoint) {
        try {
            return this.contains(breakPoint.getLineNo());
        }
        catch (BSFException bSFException) {
            return false;
        }
    }

    void propagate(int n) {
        if (this.m_validBrkptLines != null) {
            this.m_dbgScript.placeBreakpoint(n);
        }
    }

    void unpropagate(int n) {
        if (this.m_validBrkptLines != null) {
            this.m_dbgScript.removeBreakpoint(n);
        }
    }
}

