/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.ChunkedInputStream;

public class ContentLengthInputStream
extends InputStream {
    private long contentLength;
    private long pos = 0L;
    private boolean closed = false;
    private InputStream wrappedStream = null;

    public ContentLengthInputStream(InputStream inputStream, int n) {
        this(inputStream, (long)n);
    }

    public ContentLengthInputStream(InputStream inputStream, long l) {
        this.wrappedStream = inputStream;
        this.contentLength = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.closed) {
            try {
                ChunkedInputStream.exhaustInputStream(this);
            }
            finally {
                this.closed = true;
            }
        }
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.pos >= this.contentLength) {
            return -1;
        }
        ++this.pos;
        return this.wrappedStream.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.pos >= this.contentLength) {
            return -1;
        }
        if (this.pos + (long)n2 > this.contentLength) {
            n2 = (int)(this.contentLength - this.pos);
        }
        int n3 = this.wrappedStream.read(byArray, n, n2);
        this.pos += (long)n3;
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public long skip(long l) throws IOException {
        long l2 = Math.min(l, this.contentLength - this.pos);
        if ((l2 = this.wrappedStream.skip(l2)) > 0L) {
            this.pos += l2;
        }
        return l2;
    }
}

