/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.asynch;

import java.io.Serializable;
import org.jboss.aop.Advisor;
import org.jboss.aop.Dispatcher;
import org.jboss.aop.InstanceAdvised;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.proxy.Proxy;
import org.jboss.aop.proxy.ProxyFactory;
import org.jboss.aspects.NullOrZero;
import org.jboss.aspects.asynch.AsynchExecutor;
import org.jboss.aspects.asynch.ExecutorAbstraction;
import org.jboss.aspects.asynch.Future;
import org.jboss.aspects.asynch.FutureHolder;
import org.jboss.aspects.asynch.FutureInvocationHandler;
import org.jboss.aspects.asynch.RemotableFuture;
import org.jboss.aspects.asynch.ThreadPoolExecutor;
import org.jboss.aspects.remoting.Remoting;
import org.jboss.remoting.InvokerLocator;
import org.jboss.util.id.GUID;

public class AsynchAspect {
    public static final String FUTURE = "ASYNCH_FUTURE";
    private static GUID futureClassGUID = new GUID();
    private static Class[] futureIntf = new Class[]{Future.class};
    private static Class[] futureDynamicIntf = new Class[]{Future.class, Serializable.class, InstanceAdvised.class};
    private Advisor advisor;
    protected ExecutorAbstraction executor;
    private boolean generateFutureProxy = true;

    public Advisor getAdvisor() {
        return this.advisor;
    }

    public void setAdvisor(Advisor advisor) {
        this.advisor = advisor;
        Class executorClass = null;
        AsynchExecutor executorAnnotation = (AsynchExecutor)advisor.resolveAnnotation(AsynchExecutor.class);
        executorClass = executorAnnotation == null ? ThreadPoolExecutor.class : executorAnnotation.value();
        try {
            this.executor = (ExecutorAbstraction)executorClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        this.executor.setAdvisor(advisor);
    }

    public void setGenerateDynamicProxy(boolean gen) {
        this.generateFutureProxy = gen;
    }

    public Object execute(MethodInvocation invocation) throws Throwable {
        RemotableFuture future = this.executor.execute(invocation);
        InvokerLocator locator = (InvokerLocator)invocation.getMetaData((Object)"REMOTING", (Object)"INVOKER_LOCATOR");
        if (locator != null) {
            this.setupRemoteFuture(invocation, future, locator);
        } else {
            this.setupLocalFuture(invocation, future);
        }
        return NullOrZero.nullOrZero(invocation.getMethod().getReturnType());
    }

    protected void setupRemoteFuture(MethodInvocation invocation, RemotableFuture future, InvokerLocator locator) throws Exception {
        GUID futureGUID = new GUID();
        Dispatcher.singleton.registerTarget((Object)futureGUID, (Object)future);
        Proxy ia = this.generateProxy() ? ProxyFactory.createInterfaceProxy((GUID)futureClassGUID, (ClassLoader)Future.class.getClassLoader(), (Class[])futureIntf) : (InstanceAdvised)FutureInvocationHandler.createFutureProxy(futureClassGUID, Future.class.getClassLoader(), futureDynamicIntf);
        Remoting.makeRemotable((InstanceAdvised)ia, locator, futureGUID);
        future.setRemoteObjectID(futureGUID);
        invocation.addResponseAttachment((Object)FUTURE, (Object)ia);
    }

    protected boolean generateProxy() {
        return this.generateFutureProxy;
    }

    protected void setupLocalFuture(MethodInvocation invocation, Future future) {
        FutureHolder provider = (FutureHolder)invocation.getTargetObject();
        provider.setFuture(future);
        invocation.addResponseAttachment((Object)FUTURE, (Object)future);
    }
}

