/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.admin.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.faces.context.FacesContext;
import org.jboss.portal.common.i18n.LocaleManager;
import org.jboss.portal.common.i18n.LocalizedString;

public class DisplayNameBean {
    public Map createLocalizedStringMap(Locale locale, LocalizedString displayName, String name) {
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        if (displayName != null) {
            Map oldMap = displayName.getValues();
            Collection values = oldMap.values();
            for (LocalizedString.Value value : values) {
                map.put(value.getLocale(), value.getString());
            }
        }
        map.put(locale, name);
        return map;
    }

    public SortedMap getLocales() {
        TreeMap<String, String> smap = new TreeMap<String, String>();
        Locale[] localList = LocaleManager.getLocales().toArray(new Locale[0]);
        for (int i = 0; i < localList.length; ++i) {
            Locale thisLocale = localList[i];
            Locale requestedLocale = FacesContext.getCurrentInstance().getExternalContext().getRequestLocale();
            smap.put(this.convertLocaleDisplayName(thisLocale.getDisplayLanguage(requestedLocale)), thisLocale.getLanguage());
        }
        return smap;
    }

    public List populateCurrentLocales(Map displayNames) {
        ArrayList<Value> tempList = new ArrayList<Value>();
        for (Map.Entry pairs : displayNames.entrySet()) {
            Locale thisLocale = (Locale)pairs.getKey();
            Locale requestedLocale = FacesContext.getCurrentInstance().getExternalContext().getRequestLocale();
            tempList.add(new Value(thisLocale, this.convertLocaleDisplayName(thisLocale.getDisplayLanguage(requestedLocale)), this.getDisplayNameByLocale(thisLocale, displayNames)));
        }
        return tempList;
    }

    private String getDisplayNameByLocale(Locale locale, Map displayNames) {
        LocalizedString.Value lsv = (LocalizedString.Value)displayNames.get(locale);
        return lsv.getString();
    }

    private String convertLocaleDisplayName(String str) {
        if (str.length() > 0) {
            return str.substring(0, 1).toUpperCase() + str.substring(1, str.length());
        }
        return str;
    }

    public class Value {
        private String localeDisplayName;
        private Locale locale;
        private String text;

        public Value(Locale locale, String localeDisplayName, String text) {
            this.localeDisplayName = localeDisplayName;
            this.locale = locale;
            this.text = text;
        }

        public String getLocaleDisplayName() {
            return this.localeDisplayName;
        }

        public void setLocaleDisplayName(String localeDisplayName) {
            this.localeDisplayName = localeDisplayName;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public void setLocale(Locale locale) {
            this.locale = locale;
        }
    }
}

