/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.store;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.store.StoreListener;
import org.terracotta.modules.ehcache.store.bulkload.BulkLoadShutdownHook;
import org.terracotta.modules.ehcache.store.bulkload.BulkLoadToolkitCache;
import org.terracotta.toolkit.cache.ToolkitCacheListener;
import org.terracotta.toolkit.cluster.ClusterNode;
import org.terracotta.toolkit.concurrent.locks.ToolkitReadWriteLock;
import org.terracotta.toolkit.config.Configuration;
import org.terracotta.toolkit.internal.ToolkitInternal;
import org.terracotta.toolkit.internal.cache.ToolkitCacheInternal;
import org.terracotta.toolkit.internal.cache.VersionUpdateListener;
import org.terracotta.toolkit.search.QueryBuilder;
import org.terracotta.toolkit.search.attribute.ToolkitAttributeExtractor;

public class ClusteredStoreBackend<K, V>
implements ToolkitCacheInternal<K, V> {
    private final ToolkitCacheInternal<K, V> cache;
    private final BulkLoadToolkitCache<K, V> bulkloadCache;
    private ToolkitCacheInternal<K, V> activeDelegate;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public ClusteredStoreBackend(ToolkitInternal toolkit, ToolkitCacheInternal<K, V> cache, BulkLoadShutdownHook bulkLoadShutdownHook, StoreListener listener) {
        this.cache = cache;
        this.bulkloadCache = new BulkLoadToolkitCache<K, V>(toolkit, cache.getName(), cache, bulkLoadShutdownHook, listener);
        this.activeDelegate = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V putIfAbsent(K key, V value, long createTimeInSecs, int customMaxTTISeconds, int customMaxTTLSeconds) {
        this.lock.readLock().lock();
        try {
            Object object = this.activeDelegate.putIfAbsent(key, value, createTimeInSecs, customMaxTTISeconds, customMaxTTLSeconds);
            return (V)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value, int createTimeInSecs, int customMaxTTISeconds, int customMaxTTLSeconds) {
        this.lock.readLock().lock();
        try {
            Object object = this.activeDelegate.put(key, value, createTimeInSecs, customMaxTTISeconds, customMaxTTLSeconds);
            return (V)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putVersioned(K key, V value, long version) {
        this.lock.readLock().lock();
        try {
            this.activeDelegate.putVersioned(key, value, version);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putVersioned(K key, V value, long version, int createTimeInSecs, int customMaxTTISeconds, int customMaxTTLSeconds) {
        this.lock.readLock().lock();
        try {
            this.activeDelegate.putVersioned(key, value, version, createTimeInSecs, customMaxTTISeconds, customMaxTTLSeconds);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getQuiet(Object key) {
        this.lock.readLock().lock();
        try {
            Object object = this.activeDelegate.getQuiet(key);
            return (V)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, V> getAllQuiet(Collection<K> keys) {
        this.lock.readLock().lock();
        try {
            Map map = this.activeDelegate.getAllQuiet(keys);
            return map;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putNoReturn(K key, V value, long createTimeInSecs, int maxTTISeconds, int maxTTLSeconds) {
        this.lock.readLock().lock();
        try {
            this.activeDelegate.putNoReturn(key, value, createTimeInSecs, maxTTISeconds, maxTTLSeconds);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ToolkitCacheListener<K> listener) {
        this.lock.readLock().lock();
        try {
            this.activeDelegate.addListener(listener);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ToolkitCacheListener<K> listener) {
        this.lock.readLock().lock();
        try {
            this.activeDelegate.removeListener(listener);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNoReturn(Object key) {
        this.lock.readLock().lock();
        try {
            this.activeDelegate.removeNoReturn(key);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V unsafeLocalGet(Object key) {
        this.lock.readLock().lock();
        try {
            Object object = this.activeDelegate.unsafeLocalGet(key);
            return (V)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putNoReturn(K key, V value) {
        this.lock.readLock().lock();
        try {
            this.activeDelegate.putNoReturn(key, value);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int localSize() {
        this.lock.readLock().lock();
        try {
            int n = this.activeDelegate.localSize();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<K> localKeySet() {
        this.lock.readLock().lock();
        try {
            Set set = this.activeDelegate.localKeySet();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsLocalKey(Object key) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.activeDelegate.containsLocalKey(key);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, V> getAll(Collection<? extends K> keys) {
        this.lock.readLock().lock();
        try {
            Map map = this.activeDelegate.getAll(keys);
            return map;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration getConfiguration() {
        this.lock.readLock().lock();
        try {
            Configuration configuration = this.activeDelegate.getConfiguration();
            return configuration;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigField(String name, Serializable value) {
        this.lock.readLock().lock();
        try {
            this.activeDelegate.setConfigField(name, value);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object value) throws UnsupportedOperationException {
        this.lock.readLock().lock();
        try {
            boolean bl = this.activeDelegate.containsValue(value);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V putIfAbsent(K key, V value) {
        this.lock.readLock().lock();
        try {
            Object object = this.activeDelegate.putIfAbsent(key, value);
            return (V)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Map.Entry<K, V>> entrySet() {
        this.lock.readLock().lock();
        try {
            Set set = this.activeDelegate.entrySet();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<V> values() {
        this.lock.readLock().lock();
        try {
            Collection collection = this.activeDelegate.values();
            return collection;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object key, Object value) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.activeDelegate.remove(key, value);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(K key, V oldValue, V newValue) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.activeDelegate.replace(key, oldValue, newValue);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V replace(K key, V value) {
        this.lock.readLock().lock();
        try {
            Object object = this.activeDelegate.replace(key, value);
            return (V)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long localOnHeapSizeInBytes() {
        this.lock.readLock().lock();
        try {
            long l = this.activeDelegate.localOnHeapSizeInBytes();
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long localOffHeapSizeInBytes() {
        this.lock.readLock().lock();
        try {
            long l = this.activeDelegate.localOffHeapSizeInBytes();
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int localOnHeapSize() {
        this.lock.readLock().lock();
        try {
            int n = this.activeDelegate.localOnHeapSize();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int localOffHeapSize() {
        this.lock.readLock().lock();
        try {
            int n = this.activeDelegate.localOffHeapSize();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKeyLocalOnHeap(Object key) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.activeDelegate.containsKeyLocalOnHeap(key);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKeyLocalOffHeap(Object key) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.activeDelegate.containsKeyLocalOffHeap(key);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void disposeLocally() {
        this.bulkloadCache.disposeLocally();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ToolkitReadWriteLock createLockForKey(K key) {
        this.lock.readLock().lock();
        try {
            ToolkitReadWriteLock toolkitReadWriteLock = this.activeDelegate.createLockForKey(key);
            return toolkitReadWriteLock;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.lock.readLock().lock();
        try {
            int n = this.activeDelegate.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.activeDelegate.isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.activeDelegate.containsKey(key);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(Object key) {
        this.lock.readLock().lock();
        try {
            Object object = this.activeDelegate.get(key);
            return (V)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value) {
        this.lock.readLock().lock();
        try {
            Object object = this.activeDelegate.put(key, value);
            return (V)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(Object key) {
        this.lock.readLock().lock();
        try {
            Object object = this.activeDelegate.remove(key);
            return (V)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map<? extends K, ? extends V> m) {
        this.lock.readLock().lock();
        try {
            this.activeDelegate.putAll(m);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lock.readLock().lock();
        try {
            this.activeDelegate.clear();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<K> keySet() {
        this.lock.readLock().lock();
        try {
            Set set = this.activeDelegate.keySet();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDestroyed() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.activeDelegate.isDestroyed();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void destroy() {
        this.bulkloadCache.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        this.lock.readLock().lock();
        try {
            String string = this.activeDelegate.getName();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Object, Set<ClusterNode>> getNodesWithKeys(Set portableKeys) {
        this.lock.readLock().lock();
        try {
            Map map = this.activeDelegate.getNodesWithKeys(portableKeys);
            return map;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockedPutNoReturn(K k, V v, int createTime, int customTTI, int customTTL) {
        this.lock.readLock().lock();
        try {
            this.activeDelegate.unlockedPutNoReturn(k, v, createTime, customTTI, customTTL);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockedPutNoReturnVersioned(K k, V v, long version, int createTime, int customTTI, int customTTL) {
        this.lock.readLock().lock();
        try {
            this.activeDelegate.unlockedPutNoReturnVersioned(k, v, version, createTime, customTTI, customTTL);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockedRemoveNoReturn(Object k) {
        this.lock.readLock().lock();
        try {
            this.activeDelegate.unlockedRemoveNoReturn(k);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockedRemoveNoReturnVersioned(Object key, long version) {
        this.lock.readLock().lock();
        try {
            this.activeDelegate.unlockedRemoveNoReturnVersioned(key, version);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V unlockedGet(Object k, boolean quiet) {
        this.lock.readLock().lock();
        try {
            Object object = this.activeDelegate.unlockedGet(k, quiet);
            return (V)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLocalCache() {
        this.lock.readLock().lock();
        try {
            this.activeDelegate.clearLocalCache();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBulkLoadEnabledInCurrentNode(boolean enableBulkLoad) {
        this.lock.writeLock().lock();
        try {
            if (enableBulkLoad && !this.isBulkLoadEnabledInCurrentNode()) {
                this.activeDelegate = this.bulkloadCache;
                this.bulkloadCache.setBulkLoadEnabledInCurrentNode(enableBulkLoad);
            }
            if (!enableBulkLoad && this.isBulkLoadEnabledInCurrentNode()) {
                this.activeDelegate = this.cache;
                this.bulkloadCache.setBulkLoadEnabledInCurrentNode(enableBulkLoad);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void waitUntilBulkLoadCompleteInCluster() throws InterruptedException {
        this.bulkloadCache.waitUntilBulkLoadCompleteInCluster();
    }

    public boolean isBulkLoadEnabledInCluster() {
        return this.bulkloadCache.isBulkLoadEnabledInCluster();
    }

    public boolean isBulkLoadEnabledInCurrentNode() {
        return this.bulkloadCache.isBulkLoadEnabledInCurrentNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributeExtractor(ToolkitAttributeExtractor<K, V> extractor) {
        this.lock.readLock().lock();
        try {
            this.activeDelegate.setAttributeExtractor(extractor);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(Set<K> keys) {
        this.lock.readLock().lock();
        try {
            this.activeDelegate.removeAll(keys);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVersioned(Object key, long version) {
        this.lock.readLock().lock();
        try {
            this.activeDelegate.removeVersioned(key, version);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerVersionUpdateListener(VersionUpdateListener listener) {
        this.lock.readLock().lock();
        try {
            this.activeDelegate.registerVersionUpdateListener(listener);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryBuilder createQueryBuilder() {
        this.lock.readLock().lock();
        try {
            QueryBuilder queryBuilder = this.activeDelegate.createQueryBuilder();
            return queryBuilder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, V> unlockedGetAll(Collection<K> keys, boolean quiet) {
        this.lock.readLock().lock();
        try {
            Map map = this.activeDelegate.unlockedGetAll(keys, quiet);
            return map;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

