/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.faces.loader;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class FacesClassLoader
extends URLClassLoader {
    private final Logger log = Logger.getLogger(FacesClassLoader.class);
    private final Map cache = new HashMap();

    public FacesClassLoader(URL[] urls, ClassLoader classLoader) {
        super(urls, classLoader);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.startsWith("javax.faces") || name.startsWith("org.apache.myfaces")) {
            this.log.debug((Object)("Want to load " + name + " locally"));
            return this.locateClass(name);
        }
        try {
            this.log.debug((Object)("Want to load " + name + " will delegate"));
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException e) {
            this.log.debug((Object)("Not found in the parent will try to load " + name + " locally"));
            return this.locateClass(name);
        }
    }

    private Class locateClass(String name) throws ClassNotFoundException {
        Class<?> clazz = (Class<?>)this.cache.get(name);
        if (clazz == null) {
            clazz = this.findClass(name);
            this.cache.put(name, clazz);
        }
        return clazz;
    }
}

