/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.xop.jaxrpc;

import java.util.ArrayList;
import java.util.List;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;

public class XOPScanner {
    private List<String> scannedItems = new ArrayList<String>();
    private static final String BASE64_BINARY = "base64Binary";

    public XSTypeDefinition findXOPTypeDef(XSTypeDefinition typeDef) {
        String namespace;
        if (typeDef == null) {
            return typeDef;
        }
        XSTypeDefinition result = null;
        String name = typeDef.getName();
        String string = namespace = typeDef.getNamespace() != null ? typeDef.getNamespace() : "";
        if (typeDef instanceof XSSimpleTypeDefinition && BASE64_BINARY.equals(name)) {
            return typeDef;
        }
        if (typeDef instanceof XSComplexTypeDefinition) {
            XSComplexTypeDefinition complexTypeDef = (XSComplexTypeDefinition)typeDef;
            if (name != null) {
                String typeKey = namespace + ":" + name;
                if (this.scannedItems.contains(typeKey)) {
                    return null;
                }
                this.scannedItems.add(typeKey);
            }
            if (complexTypeDef.getSimpleType() != null) {
                String typeName = complexTypeDef.getSimpleType().getName();
                if (BASE64_BINARY.equals(typeName)) {
                    return complexTypeDef;
                }
            } else {
                XSTerm xterm;
                XSParticle xp;
                XSModelGroup xm = null;
                if (complexTypeDef.getContentType() != 0 && (xp = complexTypeDef.getParticle()) != null && (xterm = xp.getTerm()) instanceof XSModelGroup) {
                    xm = (XSModelGroup)xterm;
                    XSObjectList xo = xm.getParticles();
                    for (int i = 0; i < xm.getParticles().getLength(); ++i) {
                        XSTerm xsterm = ((XSParticle)xo.item(i)).getTerm();
                        if (!(xsterm instanceof XSElementDeclaration)) continue;
                        XSElementDeclaration xe = (XSElementDeclaration)xsterm;
                        XSTypeDefinition nestedTypeDef = xe.getTypeDefinition();
                        result = this.findXOPTypeDef(nestedTypeDef);
                    }
                }
            }
        }
        return result;
    }

    public void reset() {
        this.scannedItems.clear();
    }
}

